/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.formatter.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.RCRules;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.formatter.FormatterWriter;
import com.sas.dpro.formatter.standard.DefaultResultsFormatter;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.results.testing.AssociatedFile;
import com.sas.dpro.results.testing.TestResult;
import com.sas.dpro.results.testing.TestResultsReportInfo;
import com.sas.dpro.results.testing.TestSuiteResult;
import com.sas.dpro.service.Service;
import com.sas.dpro.service.ServiceInfo;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsLogger;
import com.sas.dpro.service.ServiceResultsLoggerFactory;
import com.sas.dpro.service.standard.Copy;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class ServiceResultsFormatter
extends DefaultResultsFormatter {
    public static final String PARAM_PASSING_RCS = "passingRCs";
    public static final String PARAM_RESULT_DESC_PREFIX = "resultDescriptionForRC_";
    public static final String PARAM_WARNING_RCS = "warningRCs";
    public static final String PARAM_SERVICE_LOG = "serviceLog";
    public static final String PARAM_TEST_NAME = "testName";
    public static final String PARAM_TEST_DESC = "testDescription";
    public static final String PARAM_TEST_SUITE_NAME = "testSuiteName";
    public static final String PARAM_TEST_SUITE_DESC = "testSuiteDescription";
    private static final String MSG = "com.sas.dpro.formatter.standard.ServiceResultsFormatter";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.formatter.standard.ServiceResultsFormatter");

    @Override
    protected FileListImpl doFormatImpl(Service service, ContainerContext container, ContainerContext toFormat, String[] filesToFormat, List fcsToFormat, FormatterWriter writer, Map parameters) throws ServiceFailedException {
        String serviceLog = this.getStringParam(parameters, PARAM_SERVICE_LOG);
        File localServiceLog = null;
        try {
            serviceLog = toFormat.getAbsoluteFilePath(serviceLog);
            if (container.equals(toFormat)) {
                localServiceLog = new File(serviceLog);
            } else {
                File fromFile = new File(serviceLog);
                localServiceLog = new File(container.getDirectory(), fromFile.getName());
                String providerName = toFormat.getProviderName();
                if (ProviderFactory.isLocalProvider(providerName)) {
                    Copy.copyLocal(localServiceLog, fromFile, false);
                } else {
                    Provider p = ProviderFactory.getProvider(providerName);
                    Copy.copyFromRemote(localServiceLog, p, fromFile.getAbsolutePath(), false);
                }
            }
        }
        catch (Exception e) {
            String key = "Error.CopyingServiceLog.fmt.txt";
            String desc = DProUtil.formatString(msg, key, service.getName(), serviceLog);
            throw new ServiceFailedException(desc, e);
        }
        FileListImpl fileList = new FileListImpl(container.getDirectory(), container.getProviderName(), null);
        ServiceResults oldResults = null;
        try {
            ServiceResultsLoggerFactory srlf = ServiceResultsLoggerFactory.getInstance();
            ServiceResultsLogger srl = srlf.createServiceResultsLogger();
            oldResults = srl.read(localServiceLog.getAbsolutePath());
        }
        catch (Exception e) {
            String key = "Error.ReadingServiceLog.fmt.txt";
            String desc = DProUtil.formatString(msg, key, service.getName(), e.getMessage());
            throw new ServiceFailedException(desc, e);
        }
        ServiceInfo oldServiceInfo = oldResults.getServiceInfo();
        int oldRC = oldResults.getReturnCode();
        try {
            FileList outputFiles;
            String testSuiteName = (String)parameters.get(PARAM_TEST_SUITE_NAME);
            String testName = (String)parameters.get(PARAM_TEST_NAME);
            this.debugPrint("... testSuiteName: " + testSuiteName);
            this.debugPrint("... testName:      " + testName);
            if (testSuiteName == null && (testSuiteName = testName) == null) {
                testSuiteName = oldServiceInfo.getName();
            }
            String desc = (String)parameters.get(PARAM_TEST_SUITE_DESC);
            String provider = oldServiceInfo.getHost();
            TestSuiteResult result = new TestSuiteResult(testSuiteName, desc, provider);
            result.setType(this.getType());
            result.setTime(oldResults.getTime());
            String command = oldServiceInfo.getCommand();
            if (command != null) {
                result.setCommand(command);
            }
            if (testName == null) {
                testName = oldServiceInfo.getName();
            }
            TestResult testRes = new TestResult(testName);
            desc = (String)parameters.get(PARAM_TEST_DESC);
            if (desc != null) {
                testRes.setDescription(desc);
            }
            testRes.setTime(oldResults.getTime());
            testRes.setRC(Integer.toString(oldRC));
            String passingRCs = (String)parameters.get(PARAM_PASSING_RCS);
            String warningRCs = (String)parameters.get(PARAM_WARNING_RCS);
            this.debugPrint("... passingRCs: " + passingRCs);
            this.debugPrint("... warningRCs: " + warningRCs);
            RCRules rcRules = RCRules.create(passingRCs, null);
            testRes.setExpectedRCs(rcRules.getRuleString());
            boolean set = false;
            if (warningRCs != null) {
                RCRules warningRules = RCRules.create(warningRCs, null);
                testRes.setWarningRCs(warningRules.getRuleString());
                if (!warningRules.isUnexpectedRC(oldRC)) {
                    testRes.setResult(4);
                    String resultDesc = this.getResultDescription(parameters, oldRC);
                    testRes.setResultDescription(resultDesc);
                    set = true;
                }
            }
            if (!set) {
                if (rcRules.isUnexpectedRC(oldRC)) {
                    testRes.setResult(1);
                    String resultDesc = this.getResultDescription(parameters, oldRC);
                    testRes.setResultDescription(resultDesc);
                } else {
                    testRes.setResult(0);
                }
            }
            int count = (outputFiles = oldResults.getOutputFiles()) == null ? 0 : outputFiles.getSize();
            for (int i = 0; i < count; ++i) {
                String outputFile = outputFiles.get(i);
                AssociatedFile file = new AssociatedFile(null, null, outputFile);
                file.setLocationRelativeToResultsOutput(true);
                file.setOnlyIfInResults(true);
                testRes.addAssociatedFile(file);
            }
            result.setStdout(oldResults.getStdout());
            result.setStderr(oldResults.getStderr());
            result.addTestResult(testRes);
            result.setReportInfo(new TestResultsReportInfo());
            writer.write(result);
        }
        catch (Exception e) {
            String key = "Error.WritingOutput.fmt.txt";
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            String desc = DProUtil.formatString(msg, key, service.getName(), text);
            throw new ServiceFailedException(desc, e);
        }
        return fileList;
    }

    private String getResultDescription(Map params, int rc) {
        String param = PARAM_RESULT_DESC_PREFIX + rc;
        String resultDesc = (String)params.get(param);
        if (resultDesc == null) {
            resultDesc = msg.getString("UnexpectedReturnCode.txt");
        }
        return resultDesc;
    }

    @Override
    protected String getType() {
        return "Single Service";
    }
}

