/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.formatter.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.formatter.FormatterWriter;
import com.sas.dpro.formatter.standard.DefaultResultsFormatter;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.results.testing.TestSuiteResult;
import com.sas.dpro.service.Service;
import com.sas.dpro.service.standard.Copy;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JUnitTestResultsFormatter
extends DefaultResultsFormatter {
    public static final String PARAM_JUNITDRIVER_OUTPUT_FILE = "junitResults";
    private static final String BUNDLE = "com.sas.dpro.formatter.standard.JUnitTestResultsFormatter";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.formatter.standard.JUnitTestResultsFormatter");

    private static final File createOutputFile(ContainerContext container) {
        return new File(container.getDirectory(), "TestResults.xml");
    }

    @Override
    protected FileListImpl doFormatImpl(Service service, ContainerContext container, ContainerContext toFormat, String[] filesToFormat, List fcsToFormat, FormatterWriter writer, Map parameters) throws ServiceFailedException {
        this.debugPrint("... JUnitTestResultsFormatter: Entering doFormatImpl");
        FileListImpl fileList = new FileListImpl(container.getDirectory(), container.getProviderName(), null);
        String fileName = (String)parameters.get(PARAM_JUNITDRIVER_OUTPUT_FILE);
        if (fileName == null) {
            String desc = msg.getString("Error.RequiredParameterMissing.fmt.txt");
            desc = MessageFormat.format(desc, PARAM_JUNITDRIVER_OUTPUT_FILE);
            throw new ServiceFailedException(desc);
        }
        File outputFile = JUnitTestResultsFormatter.createOutputFile(container);
        String oldFileName = null;
        try {
            oldFileName = toFormat.getAbsoluteFilePath(fileName);
        }
        catch (Exception e) {
            String desc = msg.getString("Error.GettingAbsolutePath.fmt.txt");
            desc = MessageFormat.format(desc, oldFileName);
            throw new ServiceFailedException(desc, e);
        }
        File oldFile = new File(oldFileName);
        this.debugPrint("... ... Copying JUnitDriver output file:");
        this.debugPrint("... ... " + oldFile.getAbsolutePath());
        this.debugPrint("... ... To new location:");
        this.debugPrint("... ... " + outputFile.getAbsolutePath());
        if (ProviderFactory.isLocalProvider(toFormat.getProviderName())) {
            try {
                Copy.copyLocal(outputFile, oldFile, false);
            }
            catch (IOException ioe) {
                String text = ioe.getMessage();
                if (text == null) {
                    text = ioe.toString();
                }
                String desc = msg.getString("Error.CopyingLocalFile.fmt.txt");
                desc = MessageFormat.format(desc, oldFile.getAbsolutePath(), outputFile.getAbsolutePath(), text);
                throw new ServiceFailedException(desc, ioe);
            }
        }
        try {
            Provider p = ProviderFactory.getProvider(toFormat.getProviderName());
            Copy.copyFromRemote(outputFile, p, oldFileName, false);
        }
        catch (Exception e) {
            String desc = msg.getString("Error.CopyingRemoteFile.fmt.txt");
            desc = MessageFormat.format(desc, oldFileName);
            throw new ServiceFailedException(desc, e);
        }
        this.debugPrint("... ... Parsing TestSuiteResult from newly-made file");
        TestSuiteResult tsr = new TestSuiteResult();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new BufferedInputStream(new FileInputStream(outputFile)));
            is.setEncoding("UTF-8");
            doc = db.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            String key = "Error.ParsingXML.fmt.txt";
            String desc = DProUtil.formatString(msg, key, outputFile.getAbsolutePath(), e.getMessage());
            throw new ServiceFailedException(desc);
        }
        Element root = doc.getDocumentElement();
        tsr.read(doc, root);
        this.debugPrint("... ... ... Read test suite with " + tsr.getTestResultCount() + " test results");
        writer.write(tsr);
        fileList.add(outputFile.getName());
        return fileList;
    }
}

