/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.formatter.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.ExternalProcessInfo;
import com.sas.dpro.common.ExternalProcessUtil;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.formatter.FormatterWriter;
import com.sas.dpro.formatter.XmlFormatterWritable;
import com.sas.dpro.formatter.standard.DefaultResultsFormatter;
import com.sas.dpro.service.Service;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExternalProcessBasedResultsFormatter
extends DefaultResultsFormatter {
    public static final String PARAM_COMMAND_LINE_ARGS = "commandLineArgs";
    private ExternalProcessInfo epi;
    private static final String MSG = "com.sas.dpro.formatter.standard.ExternalProcessBasedResultsFormatter";
    private static ResourceBundle errorMsg;

    public ExternalProcessBasedResultsFormatter(ExternalProcessInfo epi) {
        this.epi = epi;
    }

    @Override
    protected FileListImpl doFormatImpl(Service service, ContainerContext container, ContainerContext toFormat, String[] filesToFormat, List fcsToFormat, FormatterWriter writer, Map parameters) throws ServiceFailedException {
        this.debugPrint("External process-based formatter starting...");
        FileListImpl fileList = new FileListImpl(container.getDirectory(), container.getProviderName(), null);
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(this.epi.getCommand());
        Iterator i = this.epi.getArgIterator();
        while (i.hasNext()) {
            String arg = (String)i.next();
            cmdLine.add(arg);
        }
        Object temp = parameters.get(PARAM_COMMAND_LINE_ARGS);
        if (temp != null) {
            if (!(temp instanceof String)) {
                ResourceBundle msg = ExternalProcessBasedResultsFormatter.getErrorBundle();
                String key = "Error.WrongType.fmt.txt";
                String desc = DProUtil.formatString(msg, key, new Object[]{service.getName(), PARAM_COMMAND_LINE_ARGS, "String", temp.getClass()});
                throw new ServiceFailedException(desc);
            }
            String[] args = ((String)temp).split("\n");
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].length() <= 0) continue;
                this.debugPrint("... Adding extra command line arg: " + args[i2]);
                cmdLine.add(args[i2]);
            }
        }
        ProcessBuilder pb = new ProcessBuilder(cmdLine);
        Map<String, String> env = pb.environment();
        if (!this.epi.getAppendEnvVars()) {
            env.clear();
        }
        Iterator i3 = this.epi.getEnvVarIterator();
        while (i3.hasNext()) {
            Map.Entry entry = (Map.Entry)i3.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                env.remove(name);
                continue;
            }
            env.put(name, value);
        }
        String dir = container.getDirectory();
        pb.directory(new File(dir));
        String command = ExternalProcessUtil.createCommandString(cmdLine);
        this.debugPrint("... External process to execute: " + command);
        this.debugPrint("... Running in directory: " + dir);
        this.debugPrint("... Process starting...");
        StringBuilder stdoutBuf = new StringBuilder();
        StringBuilder stderrBuf = null;
        if (this.epi.getUseStderrInErrorMessages()) {
            stderrBuf = new StringBuilder();
        }
        int rc = 0;
        Process p = null;
        try {
            p = pb.start();
        }
        catch (Exception e) {
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            ResourceBundle msg = ExternalProcessBasedResultsFormatter.getErrorBundle();
            String key = "Error.LaunchingProcess.fmt.txt";
            String desc = DProUtil.formatString(msg, key, service.getName(), text);
            throw new ServiceFailedException(desc, e);
        }
        try {
            rc = ExternalProcessUtil.waitFor(p, null, null, stdoutBuf, stderrBuf);
        }
        catch (Exception e) {
            String text;
            if (p != null) {
                p.destroy();
            }
            if ((text = e.getMessage()) == null) {
                text = e.toString();
            }
            ResourceBundle msg = ExternalProcessBasedResultsFormatter.getErrorBundle();
            String key = "Error.RunningProcess.fmt.txt";
            String desc = DProUtil.formatString(msg, key, service.getName(), text);
            throw new ServiceFailedException(desc, e);
        }
        this.debugPrint("... Process completed!");
        this.debugPrint("... Checking return code (" + rc + ")...");
        if (rc != 0) {
            ResourceBundle msg = ExternalProcessBasedResultsFormatter.getErrorBundle();
            String desc = null;
            if (this.epi.getUseStderrInErrorMessages()) {
                String key = "Error.BadRCWithDesc.fmt.txt";
                desc = DProUtil.formatString(msg, key, service.getName(), "" + rc, stderrBuf.toString());
            } else {
                String key = "Error.BadRC.fmt.txt";
                desc = DProUtil.formatString(msg, key, service.getName(), "" + rc);
            }
            throw new ServiceFailedException(desc);
        }
        String stdout = stdoutBuf.toString();
        this.debugPrint("... Return code ok!");
        this.debugPrint("... stdout: " + stdout);
        this.debugPrint("... Converting stdout to DOM structure...");
        if (stdout.length() == 0) {
            ResourceBundle msg = ExternalProcessBasedResultsFormatter.getErrorBundle();
            String key = "Error.EmptyStdout.fmt.txt";
            String desc = DProUtil.formatString(msg, key, service.getName());
            throw new ServiceFailedException(desc);
        }
        Document doc = null;
        try {
            doc = DProUtil.stringToXMLDoc(stdout);
        }
        catch (Exception e) {
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            ResourceBundle msg = ExternalProcessBasedResultsFormatter.getErrorBundle();
            String key = "Error.ParsingXML.fmt.txt";
            String desc = DProUtil.formatString(msg, key, service.getName(), text);
            throw new ServiceFailedException(desc);
        }
        this.debugPrint("... Success!");
        this.debugPrint("... Writing formatted output from DOM to writer...");
        Element root = doc.getDocumentElement();
        XmlFormatterWritable sfw = null;
        try {
            sfw = new XmlFormatterWritable(root.getNodeName(), root);
        }
        catch (ParserConfigurationException pce) {
            String text = pce.getMessage();
            if (text == null) {
                text = pce.toString();
            }
            ResourceBundle msg = ExternalProcessBasedResultsFormatter.getErrorBundle();
            String key = "Error.CreatingWritable.fmt.txt";
            String desc = DProUtil.formatString(msg, key, service.getName(), text);
            throw new ServiceFailedException(desc);
        }
        writer.write(sfw);
        this.debugPrint("... Success!");
        this.debugPrint("External process-based formatter completed");
        return fileList;
    }

    private static synchronized ResourceBundle getErrorBundle() {
        if (errorMsg == null) {
            errorMsg = ResourceBundle.getBundle(MSG);
        }
        return errorMsg;
    }
}

