/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.formatter.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.formatter.FormatterWriter;
import com.sas.dpro.formatter.ResultsFormatter;
import com.sas.dpro.results.testing.TestResultsReportInfo;
import com.sas.dpro.results.testing.TestSuiteResult;
import com.sas.dpro.service.Service;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class DefaultResultsFormatter
implements ResultsFormatter {
    private static final String MSG = "com.sas.dpro.formatter.standard.DefaultResultsFormatter";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.formatter.standard.DefaultResultsFormatter");

    protected void debugPrint(String text) {
        if ("true".equalsIgnoreCase(System.getProperty("com.sas.dpro.formatter.ResultsFormatter.debug"))) {
            text = "[DEBUG ResultsFormatter]: " + text;
            System.out.println(text);
        }
    }

    @Override
    public final ServiceResults doFormat(Service service, ContainerContext container, ContainerContext toFormat, String[] filesToFormat, List fcsToFormat, FormatterWriter writer, Map parameters) throws ServiceFailedException {
        this.debugPrint("Calling doFormatImpl()...");
        FileListImpl fileList = this.doFormatImpl(service, container, toFormat, filesToFormat, fcsToFormat, writer, parameters);
        this.debugPrint("Completed doFormatImpl()");
        ServiceResultsImpl sr = new ServiceResultsImpl(service.createServiceInfo(), container, fileList, 0);
        this.debugPrint("Calling writer.finish()...");
        try {
            writer.finish();
        }
        catch (Exception e) {
            throw new ServiceFailedException(null, e);
        }
        String xml = writer.getXML();
        sr.setFormattedOutput(xml);
        String id = (String)parameters.get("resultsCollection");
        sr.setFormattedResultsID(id);
        this.debugPrint("Completed calling writer.finish()");
        return sr;
    }

    protected FileListImpl doFormatImpl(Service service, ContainerContext container, ContainerContext toFormat, String[] filesToFormat, List fcsToFormat, FormatterWriter writer, Map parameters) throws ServiceFailedException {
        FileListImpl fileList = new FileListImpl(container.getDirectory(), container.getProviderName(), null);
        try {
            String name = msg.getString("TestSuiteResult.Name.txt");
            String command = null;
            String server = msg.getString("TestSuiteResult.Server.txt");
            TestSuiteResult result = new TestSuiteResult(name, command, server);
            result.setType(this.getType());
            result.setReportInfo(new TestResultsReportInfo());
            writer.write(result);
            writer.finish();
        }
        catch (Exception e) {
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            String desc = msg.getString("Error.WritingOutput.fmt.txt");
            desc = MessageFormat.format(desc, service.getName(), text);
            throw new ServiceFailedException(desc, e);
        }
        return fileList;
    }

    protected String getStringParam(Map params, String paramName) throws ServiceFailedException {
        Object value = params.get(paramName);
        if (value == null) {
            String desc = msg.getString("Error.ParamMissing.fmt.txt");
            desc = MessageFormat.format(desc, paramName);
            throw new ServiceFailedException(desc);
        }
        if (!(value instanceof String)) {
            String desc = msg.getString("Error.ParamWrongType.fmt.txt");
            desc = MessageFormat.format(desc, paramName, "String", value.getClass().getName());
        }
        return (String)value;
    }

    protected String getType() {
        return "Unknown";
    }
}

