/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.formatter;

import com.sas.dpro.formatter.FormatterWritable;
import com.sas.dpro.results.InvalidResultFileException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFormatterWritable
implements FormatterWritable {
    private String rootElemName;
    private Document doc;
    private boolean writeRootNode;

    public XmlFormatterWritable(String rootElemName) throws ParserConfigurationException {
        this(rootElemName, null);
    }

    public XmlFormatterWritable(String rootElemName, Element root) throws ParserConfigurationException {
        this.rootElemName = rootElemName;
        this.doc = this.createDocument();
        Node clone = this.doc.importNode(root, true);
        this.setRoot(this.doc, clone);
        this.initialize();
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        return doc;
    }

    @Override
    public String getRootElementName() {
        return this.rootElemName;
    }

    public boolean getWriteRootNode() {
        return this.writeRootNode;
    }

    protected void initialize() {
        this.setWriteRootNode(true);
    }

    @Override
    public void read(Document doc, Element root) throws InvalidResultFileException {
        Node clone = this.doc.importNode(root, true);
        this.doc.replaceChild(clone, this.doc.getDocumentElement());
    }

    private void setRoot(Document doc, Node newRoot) {
        Element old = doc.getDocumentElement();
        if (old == null) {
            doc.appendChild(newRoot);
        } else {
            doc.replaceChild(newRoot, old);
        }
    }

    public void setWriteRootNode(boolean writeRootNode) {
        this.writeRootNode = writeRootNode;
    }

    @Override
    public void write(Document doc, Element parent) {
        if (this.getWriteRootNode()) {
            Node clone = doc.importNode(this.doc.getDocumentElement(), true);
            parent.appendChild(clone);
        } else {
            NodeList childNodes = this.doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                Node clone = doc.importNode(child, true);
                parent.appendChild(clone);
            }
        }
    }
}

