/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.controller;

import com.sas.dpro.client.AbstractClient;
import com.sas.dpro.common.DProEnvironment;
import com.sas.dpro.common.HostInfo;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.Controller;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import java.io.File;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;

class VariableManager
implements Cloneable {
    public static final String VAR_CONTRACT = "_contract";
    public static final String VAR_CONTRACT_DIR = "_contractDir";
    public static final String VAR_CONTRACT_FILE = "_contractFile";
    public static final String VAR_CURRENT_TIME_MILLIS = "_currentTimeInMilliseconds";
    public static final String VAR_DPRO_SERVER = "_dproServer";
    public static final String VAR_FILE_SEP = "_fs";
    public static final String VAR_HOST_IP = "_hostIPAddress";
    public static final String VAR_HOST_NAME = "_hostName";
    public static final String VAR_INSTALL_DIR = "_installDir";
    public static final String VAR_JAVA_VERSION = "_javaVersion";
    public static final String VAR_LAST_RC = "_lastRC";
    public static final String VAR_LOCALE = "_locale";
    public static final String VAR_LOCALE_LANGUAGE = "_language";
    public static final String VAR_LOCALE_COUNTRY = "_country";
    public static final String VAR_MAX_PARALLEL_CONTRACT_COUNT = "_parallelContractCount";
    public static final String VAR_OS_ARCH = "_osArchitecture";
    public static final String VAR_OS_NAME = "_osName";
    public static final String VAR_OS_VERSION = "_osVersion";
    public static final String VAR_PATH_SEP = "_ps";
    public static final String VAR_REPORTS_DIR = "_reportsDir";
    public static final String VAR_RESULTS_DIR = "_resultsDir";
    public static final String VAR_TEMPDIR = "_tempDir";
    public static final String VAR_TIMESTAMP = "_timeStamp";
    public static final String VAR_USERID = "_userid";
    private Map varMap;
    private HostInfo hostInfo;
    private Controller controller;
    private ContractSession contractSession;
    private boolean isClient;
    private ResourceBundle msg;
    private static final String BUNDLE = "com.sas.dpro.controller.VariableManager";

    public VariableManager(Controller controller, HostInfo hostInfo, boolean isClient) {
        this.controller = controller;
        this.hostInfo = hostInfo;
        this.isClient = isClient;
        this.initVarMap(isClient);
    }

    void addAll(String[] variables) throws UnsupportedOperationException {
        if (variables != null) {
            int i = 0;
            while (i < variables.length) {
                String name = variables[i++];
                String value = variables[i++];
                this.setVariableValue(name, value);
            }
        }
    }

    public void addVariable(String name, String value, boolean readOnly) throws UnsupportedOperationException {
        VariableInfo info = this.getVarInfo(name);
        if (info != null) {
            String desc = this.getBundle().getString("Exception.VariableAlreadyExists.fmt.txt");
            desc = MessageFormat.format(desc, name);
            throw new UnsupportedOperationException(desc);
        }
        info = new VariableInfo(value, readOnly);
        this.varMap.put(name, info);
    }

    public Object clone() throws CloneNotSupportedException {
        VariableManager man2 = (VariableManager)super.clone();
        man2.setContractSession(this.contractSession);
        man2.controller = this.controller;
        man2.isClient = this.isClient;
        man2.initVarMap(this.isClient);
        Set keySet = this.varMap.keySet();
        for (String name : keySet) {
            VariableInfo info;
            if (man2.getVarInfo(name) != null || (info = this.getVarInfo(name)) == null) continue;
            man2.addVariable(name, info.getValue(name), info.isReadOnly());
        }
        return man2;
    }

    public Map createVariableMap() {
        return this.createVariableMap(new HashMap());
    }

    private Map createVariableMap(Map map) {
        Set keySet = this.varMap.keySet();
        for (String name : keySet) {
            VariableInfo info;
            if (map.get(name) != null || (info = this.getVarInfo(name)).isReadOnly()) continue;
            String value = info.getValue(name);
            map.put(name, value);
        }
        return map;
    }

    protected synchronized ResourceBundle getBundle() {
        if (this.msg == null) {
            this.msg = ResourceBundle.getBundle(BUNDLE);
        }
        return this.msg;
    }

    public String[] getVariableNames(boolean includeReadOnly, Pattern p) {
        ArrayList<String> varNames = new ArrayList<String>();
        for (String name : this.varMap.keySet()) {
            if (!includeReadOnly && name.startsWith("_") || p != null && !p.matcher(name).matches()) continue;
            varNames.add(name);
        }
        int count = varNames.size();
        Object[] array = new String[count];
        if (count > 0) {
            array = varNames.toArray(array);
            Arrays.sort(array);
        }
        return array;
    }

    private VariableInfo getVarInfo(String name) {
        return (VariableInfo)this.varMap.get(name);
    }

    public String getVariableValue(String name) {
        String value = null;
        VariableInfo info = this.getVarInfo(name);
        if (info != null) {
            value = info.getValue(name);
        }
        return value;
    }

    private void initVarMap(boolean isClient) {
        String dproServer = null;
        AbstractClient client = this.controller.getClient();
        if (client instanceof Provider) {
            try {
                dproServer = ((Provider)((Object)client)).getProviderName();
            }
            catch (RemoteException re) {
                dproServer = "Error";
            }
        } else {
            dproServer = this.hostInfo.getHostName() + ":-99999";
        }
        this.varMap = new HashMap();
        this.varMap.put(VAR_CONTRACT, new ContractInfoVariableInfo());
        this.varMap.put(VAR_CONTRACT_DIR, this.varMap.get(VAR_CONTRACT));
        this.varMap.put(VAR_CONTRACT_FILE, this.varMap.get(VAR_CONTRACT));
        this.varMap.put(VAR_CURRENT_TIME_MILLIS, new CurrentTimeMillisVariableInfo());
        this.varMap.put(VAR_DPRO_SERVER, new VariableInfo(dproServer, true));
        this.varMap.put(VAR_FILE_SEP, new FileSeparatorVariableInfo());
        this.varMap.put(VAR_HOST_IP, new VariableInfo(this.hostInfo.getHostIPAddress(), true));
        this.varMap.put(VAR_HOST_NAME, new VariableInfo(this.hostInfo.getHostName(), true));
        this.varMap.put(VAR_INSTALL_DIR, new InstallDirVariableInfo());
        this.varMap.put(VAR_JAVA_VERSION, new VariableInfo(System.getProperty("java.version"), true));
        this.varMap.put(VAR_LAST_RC, new LastRCVariableInfo());
        this.varMap.put(VAR_LOCALE, new VariableInfo(Locale.getDefault().toString(), true));
        this.varMap.put(VAR_LOCALE_COUNTRY, new VariableInfo(Locale.getDefault().getCountry(), true));
        this.varMap.put(VAR_LOCALE_LANGUAGE, new VariableInfo(Locale.getDefault().getLanguage(), true));
        this.varMap.put(VAR_MAX_PARALLEL_CONTRACT_COUNT, new ParallelCountVariableInfo());
        this.varMap.put(VAR_OS_ARCH, new VariableInfo(this.hostInfo.getOSArchitecture(), true));
        this.varMap.put(VAR_OS_NAME, new VariableInfo(this.hostInfo.getOSName(), true));
        this.varMap.put(VAR_OS_VERSION, new VariableInfo(this.hostInfo.getOSVersion(), true));
        this.varMap.put(VAR_PATH_SEP, new PathSeparatorVariableInfo());
        this.varMap.put(VAR_REPORTS_DIR, new ReportsDirVariableInfo());
        this.varMap.put(VAR_RESULTS_DIR, new ResultsDirVariableInfo());
        this.varMap.put(VAR_TEMPDIR, new TempDirVariableInfo());
        this.varMap.put(VAR_TIMESTAMP, new TimestampVariableInfo());
        if (isClient) {
            this.varMap.put(VAR_USERID, new VariableInfo(System.getProperty("user.name"), true));
        }
    }

    protected String replaceVariables(String text) {
        if (text == null) {
            return null;
        }
        char[] chars = text.toCharArray();
        int charCount = chars.length;
        StringBuilder buffer = new StringBuilder();
        int pos = 0;
        block4: for (int i = 0; i < charCount - 1; ++i) {
            if (chars[i] != '$') continue;
            switch (chars[++i]) {
                case '{': {
                    buffer.append(chars, pos, i - pos - 1);
                    pos = i - 1;
                    while (++i < charCount) {
                        if (chars[i] != '}') continue;
                        String var = new String(chars, pos + 2, i - (pos + 2));
                        String replacement = this.getVariableValue(var);
                        buffer.append(replacement);
                        pos = i + 1;
                        continue block4;
                    }
                    continue block4;
                }
                case '$': {
                    buffer.append(chars, pos, i - pos - 1);
                    buffer.append('$');
                    pos = i + 1;
                    continue block4;
                }
            }
        }
        if (pos < charCount) {
            buffer.append(chars, pos, charCount - pos);
        }
        return buffer.toString();
    }

    public void setContractSession(ContractSession session) {
        this.contractSession = session;
    }

    public void setVariableValue(String name, String value) throws UnsupportedOperationException {
        VariableInfo info = this.getVarInfo(name);
        if (info == null) {
            info = new VariableInfo(value, false);
            this.varMap.put(name, info);
        } else {
            try {
                info.setValue(value);
            }
            catch (UnsupportedOperationException uoe) {
                String desc = this.getBundle().getString("Exception.VariableIsReadOnly.fmt.txt");
                desc = MessageFormat.format(desc, name);
                throw new UnsupportedOperationException(desc);
            }
        }
    }

    static class VariableInfo {
        private String value;
        private boolean readOnly;

        public VariableInfo(String value, boolean readOnly) {
            this.value = value;
            this.readOnly = readOnly;
        }

        public String getValue(String name) {
            return this.value;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setValue(String value) throws UnsupportedOperationException {
            if (this.isReadOnly()) {
                throw new UnsupportedOperationException();
            }
            this.value = value;
        }
    }

    class ContractInfoVariableInfo
    extends VariableInfo {
        public ContractInfoVariableInfo() {
            super(null, true);
        }

        @Override
        public String getValue(String name) {
            String value = null;
            if (VariableManager.this.contractSession != null) {
                int end;
                String contract;
                if (VariableManager.VAR_CONTRACT_DIR.equals(name)) {
                    String contract2 = VariableManager.this.contractSession.getContractName();
                    if (contract2 != null) {
                        int end2 = Math.max(contract2.lastIndexOf(47), contract2.lastIndexOf(92));
                        value = end2 > -1 ? contract2.substring(0, end2) : "";
                    }
                } else if (VariableManager.VAR_CONTRACT.equals(name)) {
                    value = VariableManager.this.contractSession.getContractName();
                } else if (VariableManager.VAR_CONTRACT_FILE.equals(name) && (contract = VariableManager.this.contractSession.getContractName()) != null && (end = Math.max(contract.lastIndexOf(47), contract.lastIndexOf(92))) > -1) {
                    value = contract.substring(end + 1);
                }
            }
            return value;
        }
    }

    class CurrentTimeMillisVariableInfo
    extends VariableInfo {
        public CurrentTimeMillisVariableInfo() {
            super(null, true);
        }

        @Override
        public String getValue(String name) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    class FileSeparatorVariableInfo
    extends VariableInfo {
        public FileSeparatorVariableInfo() {
            super(null, true);
        }

        @Override
        public String getValue(String name) {
            return File.separator;
        }
    }

    class InstallDirVariableInfo
    extends VariableInfo {
        public InstallDirVariableInfo() {
            super(null, true);
        }

        @Override
        public String getValue(String name) {
            return DProEnvironment.getInstallDirectory();
        }
    }

    class LastRCVariableInfo
    extends VariableInfo {
        public LastRCVariableInfo() {
            super(null, true);
        }

        @Override
        public String getValue(String name) {
            return "" + (VariableManager.this.contractSession == null ? Integer.MAX_VALUE : VariableManager.this.contractSession.getLastRC());
        }
    }

    class ParallelCountVariableInfo
    extends VariableInfo {
        public ParallelCountVariableInfo() {
            super(null, true);
        }

        @Override
        public String getValue(String name) {
            int parallel = 0;
            try {
                Provider p = ProviderFactory.getProvider("server-local");
                parallel = p.getMaxParallelContractCount();
            }
            catch (Exception e) {
                e.printStackTrace();
                parallel = -1;
            }
            return "" + parallel;
        }
    }

    class PathSeparatorVariableInfo
    extends VariableInfo {
        public PathSeparatorVariableInfo() {
            super(null, true);
        }

        @Override
        public String getValue(String name) {
            return File.pathSeparator;
        }
    }

    class ReportsDirVariableInfo
    extends VariableInfo {
        public ReportsDirVariableInfo() {
            super(null, true);
        }

        @Override
        public String getValue(String name) {
            return DProEnvironment.getReportsDirectory();
        }
    }

    class ResultsDirVariableInfo
    extends VariableInfo {
        public ResultsDirVariableInfo() {
            super(null, true);
        }

        @Override
        public String getValue(String name) {
            return DProEnvironment.getResultsDirectory();
        }
    }

    class TempDirVariableInfo
    extends VariableInfo {
        private String tempDir;

        public TempDirVariableInfo() {
            super(null, true);
            this.tempDir = System.getProperty("java.io.tmpdir");
            if (this.tempDir.endsWith("/") || this.tempDir.endsWith("\\")) {
                this.tempDir = this.tempDir.substring(0, this.tempDir.length() - 1);
            }
        }

        @Override
        public String getValue(String name) {
            return this.tempDir;
        }
    }

    class TimestampVariableInfo
    extends VariableInfo {
        public TimestampVariableInfo() {
            super(null, true);
        }

        @Override
        public String getValue(String name) {
            return DateFormat.getDateTimeInstance(0, 0).format(new Date());
        }
    }
}

