/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.controller;

import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.HonorContractContext;
import java.io.Serializable;

public class HonorContractContextImpl
implements HonorContractContext,
Serializable {
    private String contractFileName;
    private long contractSessionID;
    private long originalContractSessionID;
    private String provider;
    private String clientVersion;
    private String providerVersion;
    private static final long serialVersionUID = 1L;

    public HonorContractContextImpl(ContractSession session, String provider, String providerVersion, String clientVersion) {
        this.contractFileName = session.getContractName();
        this.contractSessionID = session.getSessionID();
        this.provider = provider;
        this.setClientDPROVersion(clientVersion);
        this.setProviderDPROVersion(providerVersion);
    }

    @Override
    public boolean equals(Object obj) {
        boolean eq = false;
        if (obj instanceof HonorContractContext) {
            HonorContractContext hcc = (HonorContractContext)obj;
            eq = this.contractSessionID == hcc.getContractSessionID() && (this.contractFileName == null && hcc.getContract() == null || this.contractFileName != null && this.contractFileName.equals(hcc.getContract())) && (this.provider == null && hcc.getProviderName() == null || this.provider != null && this.provider.equals(hcc.getProviderName()));
        }
        return eq;
    }

    @Override
    public String getClientDPROVersion() {
        return this.clientVersion;
    }

    @Override
    public String getContract() {
        return this.contractFileName;
    }

    @Override
    public long getContractSessionID() {
        return this.contractSessionID;
    }

    @Override
    public long getOriginalContractSessionID() {
        return this.originalContractSessionID != -1L ? this.originalContractSessionID : this.contractSessionID;
    }

    @Override
    public String getProviderDPROVersion() {
        return this.providerVersion;
    }

    @Override
    public String getProviderName() {
        return this.provider;
    }

    public int hashCode() {
        return (int)this.contractSessionID;
    }

    @Override
    public boolean isRunningRemotely() {
        return this.provider != null;
    }

    public void setClientDPROVersion(String clientDPROVersion) {
        this.clientVersion = clientDPROVersion;
    }

    public void setOriginalContractSessionID(long id) {
        this.originalContractSessionID = id;
    }

    public void setProviderDPROVersion(String providerDPROVersion) {
        this.providerVersion = providerDPROVersion;
    }

    public String toString() {
        return "[HonorContractContextImpl: contract=" + this.getContract() + ", contractSessionID=" + this.getContractSessionID() + ", providerName=" + this.getProviderName() + ", runningRemotely=" + this.isRunningRemotely() + ", clientDPROVersion=" + this.getClientDPROVersion() + ", providerDPROVersion=" + this.getProviderDPROVersion() + ", originalContractSessionID=" + this.getOriginalContractSessionID() + "]";
    }
}

