/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.controller;

import com.sas.dpro.client.AbstractClient;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InputPromptInfo;
import com.sas.dpro.common.Macro;
import com.sas.dpro.contract.messages.ContractCompletedMessage;
import com.sas.dpro.contract.messages.DPROSystemMessageImpl;
import com.sas.dpro.contract.messages.Message;
import com.sas.dpro.contract.messages.MessageQueue;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.ContractSessionThread;
import com.sas.dpro.controller.Controller;
import com.sas.dpro.controller.HonorContractContext;
import com.sas.dpro.controller.HonorContractContextImpl;
import com.sas.dpro.controller.HonorContractParms;
import com.sas.dpro.controller.MessageQueueImpl;
import com.sas.dpro.controller.VariableManager;
import com.sas.dpro.formatter.FormatterReader;
import com.sas.dpro.formatter.FormatterReaderImpl;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class ControllerImpl
implements Controller {
    private AbstractClient client;
    private FormatterReader formatterReader;
    private Logger logger;
    private MessageQueueImpl messageQueue;
    private VariableManager variableManager;
    private Timer contractTimeoutTimer;
    private long contractSessionID;
    private List waitingContractSessions;
    private List activeContractSessions;
    private List pausedContractSessions;
    private List completedContractSessions;
    private int maxParallelContractCount;
    private int messageGranularity;
    private long shutdownWaitTime;
    private int contractSessionCount;
    private final Object LOCK_INPUT_PROMPT = new Object();
    private final Object LOCK_SESSION_ID = new Object();
    private static final String BUNDLE = "com.sas.dpro.controller.ControllerImpl";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.controller.ControllerImpl");
    private static final String CLASS_NAME = "com.sas.dpro.controller.ControllerImpl";
    private static final String CONTRACT_TIMEOUT_TIMER_NAME = "ContractTimeoutTimer";
    private static final int DEFAULT_MAX_PARALLEL_CONTRACT_COUNT = 5;
    private static final long DEFAULT_SHUTDOWN_WAIT_TIME = 5000L;

    public ControllerImpl(AbstractClient client, Logger logger) {
        this.client = client;
        this.logger = logger;
        this.formatterReader = new FormatterReaderImpl();
        this.messageQueue = new MessageQueueImpl();
        boolean isClient = !(client instanceof Provider);
        this.variableManager = new VariableManager(this, client.getHostInfo(), isClient);
        this.contractTimeoutTimer = new Timer(CONTRACT_TIMEOUT_TIMER_NAME, true);
        this.waitingContractSessions = new ArrayList();
        this.activeContractSessions = new ArrayList(5);
        this.pausedContractSessions = new ArrayList(0);
        this.completedContractSessions = new ArrayList();
        this.setMaxParallelContractCount(5);
        this.setMessageGranularity(1);
        this.setShutdownWaitTime(5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGlobalVariable(String name, String value, boolean readOnly) throws UnsupportedOperationException {
        VariableManager variableManager = this.variableManager;
        synchronized (variableManager) {
            this.variableManager.addVariable(name, value, readOnly);
        }
    }

    public void addTimeoutRunnable(final Runnable r, long delay) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                r.run();
            }
        };
        this.contractTimeoutTimer.schedule(task, delay *= 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableManager createVariableManager(String[] variables) {
        VariableManager vm = null;
        VariableManager variableManager = this.variableManager;
        synchronized (variableManager) {
            try {
                vm = (VariableManager)this.variableManager.clone();
            }
            catch (CloneNotSupportedException cnse) {
                cnse.printStackTrace();
            }
        }
        vm.addAll(variables);
        return vm;
    }

    private final int fixMessageGranularity(int granularity) {
        if (granularity < 1 || granularity > 2) {
            granularity = this.getMessageGranularity();
        }
        return granularity;
    }

    @Override
    public ResourceBundle getBundle() {
        return msg;
    }

    @Override
    public AbstractClient getClient() {
        return this.client;
    }

    @Override
    public int getContractSessionCount() {
        return this.contractSessionCount;
    }

    @Override
    public FormatterReader getFormatterReader() {
        return this.formatterReader;
    }

    @Override
    public String getGlobalVariableValue(String name) {
        return this.variableManager.getVariableValue(name);
    }

    Logger getLogger() {
        return this.logger;
    }

    @Override
    public int getMessageGranularity() {
        return this.messageGranularity;
    }

    @Override
    public int getMaxParallelContractCount() {
        return this.maxParallelContractCount != Integer.MAX_VALUE ? this.maxParallelContractCount : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message getNextMessage() {
        Message message = this.messageQueue.dequeue();
        if (message instanceof ContractCompletedMessage) {
            HonorContractContext hcc = message.getHonorContractContext();
            List list = this.completedContractSessions;
            synchronized (list) {
                boolean found = false;
                Iterator i = this.completedContractSessions.iterator();
                while (i.hasNext()) {
                    ContractSession cs = (ContractSession)i.next();
                    if (!cs.getHonorContractContext().equals(hcc)) continue;
                    i.remove();
                    --this.contractSessionCount;
                    found = true;
                    break;
                }
                if (!found) {
                    String desc = msg.getString("Warning.CompletedSessionNotFound2.fmt.txt");
                    this.logger.warning(desc);
                }
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message getNextMessage(HonorContractContext context) {
        if (context == null || !context.isRunningRemotely()) {
            String desc = msg.getString("Error.Internal.RemoteHCCExpected.fmt.txt");
            desc = MessageFormat.format(desc, context);
            throw new IllegalArgumentException(desc);
        }
        ContractSession cs = null;
        List list = this.waitingContractSessions;
        synchronized (list) {
            for (ContractSession temp : this.waitingContractSessions) {
                if (!temp.getHonorContractContext().equals(context)) continue;
                cs = temp;
                break;
            }
        }
        if (cs == null) {
            list = this.activeContractSessions;
            synchronized (list) {
                for (ContractSession temp : this.activeContractSessions) {
                    if (!temp.getHonorContractContext().equals(context)) continue;
                    cs = temp;
                    break;
                }
            }
        }
        if (cs == null) {
            list = this.pausedContractSessions;
            synchronized (list) {
                for (ContractSession temp : this.pausedContractSessions) {
                    if (!temp.getHonorContractContext().equals(context)) continue;
                    cs = temp;
                    break;
                }
            }
        }
        if (cs == null) {
            list = this.completedContractSessions;
            synchronized (list) {
                for (ContractSession temp : this.completedContractSessions) {
                    if (!temp.getHonorContractContext().equals(context)) continue;
                    cs = temp;
                    break;
                }
            }
        }
        Message message = null;
        if (cs != null && (message = cs.getMessageQueue().dequeue()) instanceof ContractCompletedMessage) {
            List list2 = this.completedContractSessions;
            synchronized (list2) {
                if (this.completedContractSessions.remove(cs)) {
                    --this.contractSessionCount;
                } else {
                    String desc = msg.getString("Warning.CompletedSessionNotFound2.fmt.txt");
                    this.logger.warning(desc);
                }
            }
        }
        return message;
    }

    @Override
    public long getShutdownWaitTime() {
        return this.shutdownWaitTime;
    }

    @Override
    public HonorContractContext honorContract(HonorContractParms params) {
        return this.honorContract(params, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HonorContractContext honorContract(HonorContractParms parms, boolean runningRemotely) {
        File contract = null;
        String codeFragment = null;
        if (parms.getContract() != null) {
            contract = new File(parms.getContract());
        }
        codeFragment = parms.getContractCode();
        if (contract == null || codeFragment != null) {
            // empty if block
        }
        FileList[] fileLists = parms.getFileLists();
        FileSet[] fileSets = parms.getFileSets();
        Macro[] macros = parms.getMacros();
        String[] variables = parms.getVariables();
        int messageGranularity = parms.getMessageGranularity();
        MessageQueueImpl queue = runningRemotely ? new MessageQueueImpl() : this.messageQueue;
        long sessionID = 0L;
        Object object = this.LOCK_SESSION_ID;
        synchronized (object) {
            sessionID = this.contractSessionID++;
        }
        ContractSessionThread t = null;
        t = contract != null ? new ContractSessionThread(this, sessionID, variables, fileLists, fileSets, macros, contract, (MessageQueue)queue) : new ContractSessionThread(this, sessionID, variables, fileLists, fileSets, macros, codeFragment, (MessageQueue)queue);
        t.setName("ContractSessionThread-" + sessionID);
        t.setMessageGranularity(this.fixMessageGranularity(messageGranularity));
        String providerVersion = this.getClient().getClientDPROVersion();
        String provider = runningRemotely ? ProviderFactory.getLocalProviderName() : null;
        HonorContractContextImpl hcc = new HonorContractContextImpl(t, provider, providerVersion, parms.getClientDPROVersion());
        hcc.setOriginalContractSessionID(parms.getOriginalContractSessionID());
        t.setHonorContractContext(hcc);
        List list = this.activeContractSessions;
        synchronized (list) {
            if (this.activeContractSessions.size() < this.maxParallelContractCount) {
                this.activeContractSessions.add(t);
                t.startSession();
                ++this.contractSessionCount;
                String desc = "Starting contract session: " + t + "; active sessions=" + this.activeContractSessions.size();
                this.logger.finer(desc);
            } else {
                List list2 = this.waitingContractSessions;
                synchronized (list2) {
                    this.waitingContractSessions.add(t);
                    ++this.contractSessionCount;
                    String desc = "Adding contract session to wait queue: " + t + "; waiting sessions=" + this.waitingContractSessions.size();
                    this.logger.finer(desc);
                }
            }
        }
        return hcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadVariablesFromFile(String fileName) throws IOException {
        PropertyResourceBundle bundle = null;
        try {
            FileInputStream in = new FileInputStream(fileName);
            bundle = new PropertyResourceBundle(in);
            in.close();
        }
        catch (IOException ioe) {
            String desc = msg.getString("ControllerImpl.Exception.BadVariableFile.fmt.txt");
            desc = MessageFormat.format(desc, ioe.getMessage());
            throw new IOException(desc);
        }
        VariableManager variableManager = this.variableManager;
        synchronized (variableManager) {
            Enumeration<String> e = ((ResourceBundle)bundle).getKeys();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                String value = bundle.getString(name);
                value = this.variableManager.replaceVariables(value);
                this.variableManager.setVariableValue(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(ContractSession session) {
        List list = this.activeContractSessions;
        synchronized (list) {
            String desc;
            boolean found = this.activeContractSessions.remove(session);
            if (!found) {
                String desc2 = msg.getString("Warning.SessionToPauseNotFound.fmt.txt");
                desc2 = MessageFormat.format(desc2, session.toString());
                this.logger.warning(desc2);
                return;
            }
            Object desc2 = this.pausedContractSessions;
            synchronized (desc2) {
                this.pausedContractSessions.add(session);
                desc = "Contract session added to 'paused' queue: " + session;
                this.logger.finer(desc);
            }
            if (!this.waitingContractSessions.isEmpty() && this.activeContractSessions.size() <= this.maxParallelContractCount) {
                ContractSession cs = (ContractSession)this.waitingContractSessions.remove(0);
                this.activeContractSessions.add(cs);
                desc = "Starting new contract session: " + cs + ", active sessions=" + this.activeContractSessions.size() + ", paused sessions=" + this.pausedContractSessions.size() + ", waiting sessions=" + this.waitingContractSessions.size();
                this.logger.finer(desc);
                if (!cs.isStarted()) {
                    cs.startSession();
                } else {
                    cs.endWait();
                }
            } else {
                desc2 = "New active sessions=" + this.activeContractSessions.size();
                this.logger.finer((String)desc2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String promptForInput(InputPromptInfo info) throws IOException {
        Object object = this.LOCK_INPUT_PROMPT;
        synchronized (object) {
            return this.client.promptForInput(info);
        }
    }

    @Override
    public String replaceGlobalVariables(String text) {
        return this.variableManager.replaceVariables(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionCompleted(ContractSession session, ContractCompletedMessage ccm) {
        List list = this.activeContractSessions;
        synchronized (list) {
            String desc;
            boolean found = this.activeContractSessions.remove(session);
            if (!found) {
                String desc2 = msg.getString("Warning.CompletedSessionNotFound.fmt.txt");
                desc2 = MessageFormat.format(desc2, session.toString());
                this.logger.warning(desc2);
                return;
            }
            Object desc2 = this.completedContractSessions;
            synchronized (desc2) {
                this.completedContractSessions.add(session);
                desc = "Contract session completed: " + session;
                this.logger.finer(desc);
            }
            session.getMessageQueue().enqueue(ccm);
            if (!this.waitingContractSessions.isEmpty() && this.activeContractSessions.size() <= this.maxParallelContractCount) {
                ContractSession cs = (ContractSession)this.waitingContractSessions.remove(0);
                this.activeContractSessions.add(cs);
                desc = "Starting new contract session: " + cs + ", active sessions=" + this.activeContractSessions.size() + ", paused sessions=" + this.pausedContractSessions.size() + ", waiting sessions=" + this.waitingContractSessions.size();
                this.logger.finer(desc);
                if (!cs.isStarted()) {
                    cs.startSession();
                } else {
                    cs.endWait();
                }
            } else {
                desc2 = "New active sessions=" + this.activeContractSessions.size();
                this.logger.finer((String)desc2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalVariableValue(String name, String value) throws UnsupportedOperationException {
        VariableManager variableManager = this.variableManager;
        synchronized (variableManager) {
            this.variableManager.setVariableValue(name, value);
        }
    }

    @Override
    public void setMessageGranularity(int granularity) {
        this.messageGranularity = this.fixMessageGranularity(granularity);
    }

    @Override
    public void setMaxParallelContractCount(int parallel) {
        if (parallel <= 0) {
            parallel = Integer.MAX_VALUE;
        }
        this.maxParallelContractCount = parallel;
    }

    @Override
    public void setShutdownWaitTime(long ms) {
        this.shutdownWaitTime = ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        DPROSystemMessageImpl msg;
        String provider;
        String desc;
        HonorContractContext hcc;
        this.getLogger().entering("com.sas.dpro.controller.ControllerImpl", "shutdown");
        this.contractTimeoutTimer.cancel();
        boolean wait = false;
        List list = this.waitingContractSessions;
        synchronized (list) {
            for (ContractSession session : this.waitingContractSessions) {
                hcc = session.getHonorContractContext();
                desc = ControllerImpl.msg.getString("SystemMessage.SystemShuttingDownNotRunning.fmt.txt");
                provider = hcc.getProviderName();
                if (provider == null) {
                    provider = "server-local";
                }
                desc = MessageFormat.format(desc, provider);
                msg = new DPROSystemMessageImpl(hcc, desc);
                msg.setServerShuttingDown(true);
                session.getMessageQueue().enqueue(msg);
                wait = true;
            }
        }
        list = this.activeContractSessions;
        synchronized (list) {
            for (ContractSession session : this.activeContractSessions) {
                hcc = session.getHonorContractContext();
                desc = ControllerImpl.msg.getString("SystemMessage.SystemShuttingDownTerminating.fmt.txt");
                provider = hcc.getProviderName();
                if (provider == null) {
                    provider = "server-local";
                }
                desc = MessageFormat.format(desc, provider);
                msg = new DPROSystemMessageImpl(hcc, desc);
                msg.setServerShuttingDown(true);
                session.getMessageQueue().enqueue(msg);
                session.interrupt();
                wait = true;
            }
        }
        list = this.pausedContractSessions;
        synchronized (list) {
            for (ContractSession session : this.pausedContractSessions) {
                hcc = session.getHonorContractContext();
                desc = ControllerImpl.msg.getString("SystemMessage.SystemShuttingDownTerminating.fmt.txt");
                provider = hcc.getProviderName();
                if (provider == null) {
                    provider = "server-local";
                }
                desc = MessageFormat.format(desc, provider);
                msg = new DPROSystemMessageImpl(hcc, desc);
                msg.setServerShuttingDown(true);
                session.getMessageQueue().enqueue(msg);
                session.interrupt();
                wait = true;
            }
        }
        if (wait) {
            long shutdownWaitTimeMS = this.getShutdownWaitTime();
            String desc2 = ControllerImpl.msg.getString("WaitingForContracts.fmt.txt");
            desc2 = MessageFormat.format(desc2, new Long(shutdownWaitTimeMS / 1000L));
            this.getLogger().warning(desc2);
            try {
                Thread.sleep(shutdownWaitTimeMS);
            }
            catch (InterruptedException ie) {
                desc2 = ControllerImpl.msg.getString("Error.InterruptedWaitingForContracts.fmt.txt");
                desc2 = MessageFormat.format(desc2, ie.getMessage());
                this.getLogger().warning(desc2);
            }
        }
        this.getLogger().exiting("com.sas.dpro.controller.ControllerImpl", "shutdown");
    }

    public void stopContract(HonorContractContext hcc) {
        throw new UnsupportedOperationException("Stopping sessions unsupported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpause(ContractSession session) {
        String desc = "Resuming paused session: " + session;
        this.logger.finer(desc);
        List list = this.pausedContractSessions;
        synchronized (list) {
            boolean found = this.pausedContractSessions.remove(session);
            if (!found) {
                desc = msg.getString("Warning.PausedSessionNotFound.fmt.txt");
                desc = MessageFormat.format(desc, session);
                this.logger.warning(desc);
                return;
            }
            List list2 = this.activeContractSessions;
            synchronized (list2) {
                if (this.activeContractSessions.size() <= this.maxParallelContractCount) {
                    desc = "Moving back to active list: " + session;
                    this.logger.finer(desc);
                    this.activeContractSessions.add(session);
                    session.endWait();
                } else {
                    List list3 = this.waitingContractSessions;
                    synchronized (list3) {
                        desc = "Active list full; placing at front of waiting queue: " + session;
                        this.logger.finer(desc);
                        this.waitingContractSessions.add(0, session);
                    }
                }
            }
        }
    }
}

