/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.Mapper;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.contract.parser.FileListNodeHandler;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class ZipNodeHandler
extends DefaultInternalServiceNodeHandler {
    private static final String ATTR_DIR_IN_ENTRIES = "dirInEntries";
    private static final String ATTR_PREFIX = "prefix";

    public ZipNodeHandler() {
        super("Zip");
    }

    @Override
    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        ArrayList<String> dirList = new ArrayList<String>(1);
        ArrayList<String> dirInEntryList = new ArrayList<String>(1);
        ArrayList<String> dirPrefixList = new ArrayList<String>(1);
        ArrayList<FileList> fileListList = new ArrayList<FileList>(1);
        ArrayList<String> fileListPrefixList = new ArrayList<String>(1);
        ArrayList mapperList = null;
        for (Element elem : childNodeList) {
            String orig;
            String elemName = elem.getName();
            if ("dir".equals(elemName)) {
                if (!this.checkIfAttribute(elem, session, contract)) continue;
                String value = session.replaceVariables(elem.getText());
                dirList.add(value);
                String orig2 = elem.getAttributeValue(ATTR_DIR_IN_ENTRIES);
                String contentsOnlyStr = session.replaceVariables(orig2);
                boolean dirInEntry = runner.ensureBoolean(contentsOnlyStr, this.getHandledNodeType(), ATTR_DIR_IN_ENTRIES, orig2);
                dirInEntryList.add("" + dirInEntry);
                orig2 = elem.getAttributeValue(ATTR_PREFIX);
                String prefix = session.replaceVariables(orig2);
                dirPrefixList.add(prefix);
                continue;
            }
            if ("fileList".equals(elemName)) {
                if (!this.checkIfAttribute(elem, session, contract)) continue;
                ContainerContext c = this.getContainer(session, this.getHandledNodeType(), params);
                String root = c.getDirectory();
                String provider = c.getProviderName();
                FileListImpl fl = new FileListImpl(root, provider, null);
                FileListNodeHandler.parseFileListNodes(this.getHandledNodeType(), fl, c, elem, runner, session, contract);
                fileListList.add(fl);
                continue;
            }
            if ("fileListRef".equals(elemName)) {
                if (!this.checkIfAttribute(elem, session, contract)) continue;
                orig = elem.getAttributeValue("refId");
                FileList fl = this.getFileListChecked(orig, session, runner, contract, true);
                fileListList.add(fl);
                orig = elem.getAttributeValue(ATTR_PREFIX);
                String prefix = session.replaceVariables(orig);
                fileListPrefixList.add(prefix);
                continue;
            }
            if ("fileSetRef".equals(elemName)) {
                if (!this.checkIfAttribute(elem, session, contract)) continue;
                orig = elem.getAttributeValue("refId");
                FileSet fs = this.getFileSetChecked(orig, session, runner, contract, true);
                FileList fl = fs.getMatchingFiles();
                fileListList.add(fl);
                orig = elem.getAttributeValue(ATTR_PREFIX);
                String prefix = session.replaceVariables(orig);
                fileListPrefixList.add(prefix);
                continue;
            }
            if (!"mappers".equals(elemName)) continue;
            if (mapperList == null) {
                mapperList = new ArrayList(1);
            }
            this.parseMappersNode(elem, runner, session, contract, mapperList);
        }
        if (!dirList.isEmpty()) {
            String[] dirs = new String[dirList.size()];
            dirs = dirList.toArray(dirs);
            params.put("_dirs", dirs);
            String[] dirInEntrys = new String[dirList.size()];
            dirInEntrys = dirInEntryList.toArray(dirInEntrys);
            params.put("_dirsDirInEntries", dirInEntrys);
            if (dirPrefixList.size() > 0) {
                String[] dirPrefixes = new String[dirPrefixList.size()];
                dirPrefixes = dirPrefixList.toArray(dirPrefixes);
                params.put("_dirsPrefixes", dirPrefixes);
            }
        }
        if (!fileListList.isEmpty()) {
            FileList[] fileLists = new FileList[fileListList.size()];
            fileLists = fileListList.toArray(fileLists);
            params.put("_fileLists", fileLists);
            if (fileListPrefixList.size() > 0) {
                String[] flPrefixes = new String[fileListPrefixList.size()];
                flPrefixes = fileListPrefixList.toArray(flPrefixes);
                params.put("_fileListPrefixes", flPrefixes);
            }
        }
        if (mapperList != null && mapperList.size() > 0) {
            Mapper[] array = new Mapper[mapperList.size()];
            array = mapperList.toArray(array);
            params.put("mappers", array);
        }
    }
}

