/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class XsltNodeHandler
extends DefaultInternalServiceNodeHandler {
    private static final String PARAM_FROM_DIR = "fromDir";
    private static final String PARAM_FROM_FILE = "fromFile";
    private static final String PARAM_FROM_FILE_LIST = "fromFileList";
    private static final String PARAM_FROM_FILE_SET = "fromFileSet";

    public XsltNodeHandler() {
        super("Xslt");
    }

    @Override
    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        ArrayList<String> paramList = null;
        ArrayList<String> fromDirList = null;
        ArrayList<String> fromFileList = null;
        ArrayList<FileList> fromFileListList = null;
        ArrayList<FileSet> fromFileSetList = null;
        ArrayList<Integer> inputOrderList = new ArrayList<Integer>(1);
        for (Element elem : childNodeList) {
            String orig;
            String value;
            String elemName = elem.getName();
            if (elemName.equals(PARAM_FROM_DIR)) {
                value = session.replaceVariables(elem.getText());
                if (fromDirList == null) {
                    fromDirList = new ArrayList<String>(1);
                }
                fromDirList.add(value);
                inputOrderList.add(new Integer(0));
                continue;
            }
            if (elemName.equals(PARAM_FROM_FILE)) {
                value = session.replaceVariables(elem.getText());
                if (fromFileList == null) {
                    fromFileList = new ArrayList<String>(1);
                }
                fromFileList.add(value);
                inputOrderList.add(new Integer(1));
                continue;
            }
            if (elemName.equals(PARAM_FROM_FILE_LIST)) {
                orig = elem.getText();
                if (fromFileListList == null) {
                    fromFileListList = new ArrayList<FileList>(1);
                }
                FileList fl = this.getFileListChecked(orig, session, runner, contract, true);
                fromFileListList.add(fl);
                inputOrderList.add(new Integer(2));
                continue;
            }
            if (elemName.equals(PARAM_FROM_FILE_SET)) {
                orig = elem.getText();
                if (fromFileSetList == null) {
                    fromFileSetList = new ArrayList<FileSet>(1);
                }
                FileSet fs = this.getFileSetChecked(orig, session, runner, contract, true);
                fromFileSetList.add(fs);
                inputOrderList.add(new Integer(3));
                continue;
            }
            if (elemName.equals("toDir")) {
                value = session.replaceVariables(elem.getText());
                params.put(elemName, value);
                continue;
            }
            if (elemName.equals("toFile")) {
                value = session.replaceVariables(elem.getText());
                params.put(elemName, value);
                continue;
            }
            if (elemName.equals("xslt")) {
                value = session.replaceVariables(elem.getText());
                params.put(elemName, value);
                continue;
            }
            if (!elemName.equals("param")) continue;
            String name = elem.getAttributeValue("name");
            name = session.replaceVariables(name);
            String value2 = elem.getAttributeValue("value");
            if (value2 != null) {
                value2 = session.replaceVariables(value2);
                if (paramList == null) {
                    paramList = new ArrayList<String>(2);
                }
                paramList.add(name);
                paramList.add(value2);
                continue;
            }
            String loc = elem.getAttributeValue("location");
            if (loc == null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.ValueOrLocation.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType());
                throw new InvalidContractException(desc);
            }
            loc = session.replaceVariables(loc);
            ContainerContext cont = this.getContainer(session, this.getHandledNodeType(), params);
            try {
                loc = cont.getAbsoluteFilePath(loc);
            }
            catch (Exception e) {
                throw new InvalidContractException(contract, (Throwable)e);
            }
            paramList.add(name);
            paramList.add(loc);
        }
        if (fromDirList != null) {
            String[] dirs = new String[fromDirList.size()];
            dirs = fromDirList.toArray(dirs);
            params.put("_inputFromDirs", dirs);
        }
        if (fromFileList != null) {
            String[] files = new String[fromFileList.size()];
            files = fromFileList.toArray(files);
            params.put("_inputFromFiles", files);
        }
        if (fromFileListList != null) {
            FileList[] fl = new FileList[fromFileListList.size()];
            fl = fromFileListList.toArray(fl);
            params.put("_inputFromFileLists", fl);
        }
        if (fromFileSetList != null) {
            FileSet[] fs = new FileSet[fromFileSetList.size()];
            fs = fromFileSetList.toArray(fs);
            params.put("_inputFromFileSets", fs);
        }
        int intCount = inputOrderList.size();
        int[] ints = new int[intCount];
        for (int i = 0; i < intCount; ++i) {
            ints[i] = (Integer)inputOrderList.get(i);
        }
        params.put("_inputOrderArray", ints);
        if (paramList != null && paramList.size() > 0) {
            String[] paramArray = new String[paramList.size()];
            paramArray = paramList.toArray(paramArray);
            params.put("paramList", paramArray);
        }
    }
}

