/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.contract.parser.SetNodeHandler;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.jdom2.Element;

class UnsetNodeHandler
extends SetNodeHandler {
    public static final String HANDLED_NODE_TYPE = "unset";
    private static final String ATTR_NAME = "name";

    UnsetNodeHandler() {
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String orig = node.getAttributeValue(ATTR_NAME);
        String varName = session.replaceVariables(orig);
        if (!DProUtil.isValidVariableName(varName)) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.InvalidVarName.fmt.txt");
            desc = MessageFormat.format(desc, HANDLED_NODE_TYPE, orig, varName);
            throw new InvalidContractException(desc, contract);
        }
        session.setVariableValue(varName, null);
        DefaultNodeHandlerResults results = new DefaultNodeHandlerResults();
        return results;
    }
}

