/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;

public class TrimWhitespaceNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "trimWhitespace";
    private static final String ATTR_LEADING = "leading";
    private static final String ATTR_RESULT_VAR = "resultVar";
    private static final String ATTR_TRAILING = "trailing";
    private static final String ATTR_VARIABLE = "variable";

    public TrimWhitespaceNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        int start;
        String varName;
        String orig = node.getAttributeValue(ATTR_VARIABLE);
        String resultVarName = varName = this.getVariableNameChecked(orig, true, session, runner, contract);
        orig = node.getAttributeValue(ATTR_RESULT_VAR);
        if (orig != null) {
            resultVarName = this.getVariableNameChecked(orig, false, session, runner, contract);
        }
        orig = node.getAttributeValue(ATTR_LEADING);
        String leadingStr = session.replaceVariables(orig);
        boolean leading = runner.ensureBoolean(leadingStr, this.getHandledNodeType(), ATTR_LEADING, orig);
        orig = node.getAttributeValue(ATTR_TRAILING);
        String trailingStr = session.replaceVariables(orig);
        boolean trailing = runner.ensureBoolean(trailingStr, this.getHandledNodeType(), ATTR_TRAILING, orig);
        String varValue = session.getVariableValue(varName);
        int len = varValue.length();
        if (leading) {
            for (start = 0; start < len && varValue.charAt(start) <= ' '; ++start) {
            }
        }
        if (trailing) {
            while (start < len && varValue.charAt(len - 1) <= ' ') {
                --len;
            }
        }
        if (start > 0 || len < varValue.length()) {
            varValue = varValue.substring(start, len);
        }
        session.setVariableValue(resultVarName, varValue);
        return new DefaultNodeHandlerResults();
    }
}

