/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jdom2.Element;

public class TokenizeNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "tokenize";
    public static final String TYPE_REGEX = "regex";
    public static final String TYPE_TEXT = "text";
    protected static final String ATTR_COUNT_VAR = "countVar";
    protected static final String ATTR_DELIM = "delimiter";
    protected static final String ATTR_DELIM_TYPE = "delimType";
    protected static final String ATTR_IGNORE_CASE = "ignoreCase";
    private static final String ATTR_TOKEN_PREFIX = "tokenPrefix";
    protected static final String ATTR_TO_SPLIT = "toSplit";
    protected static final boolean DEFAULT_IGNORE_CASE = false;

    public TokenizeNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    protected TokenizeNodeHandler(String handledNodeType) {
        super(handledNodeType);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String orig = node.getAttributeValue(ATTR_TO_SPLIT);
        String toSplit = session.replaceVariables(orig);
        orig = node.getAttributeValue(ATTR_TOKEN_PREFIX);
        String prefix = session.replaceVariables(orig);
        String countVar = null;
        orig = node.getAttributeValue(ATTR_COUNT_VAR);
        if (orig != null) {
            countVar = this.getVariableNameChecked(orig, false, session, runner, contract);
        }
        String type = TYPE_TEXT;
        orig = node.getAttributeValue(ATTR_DELIM_TYPE);
        if (orig != null && !TokenizeNodeHandler.isValidDelimType(type = session.replaceVariables(orig))) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.InvalidAttribute.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), ATTR_DELIM_TYPE, type, orig);
            throw new ContractSyntaxException(desc, contract);
        }
        String origDelim = node.getAttributeValue(ATTR_DELIM);
        String delim = session.replaceVariables(origDelim);
        boolean ignoreCase = false;
        orig = node.getAttributeValue(ATTR_IGNORE_CASE);
        if (orig != null) {
            String value = session.replaceVariables(orig);
            ignoreCase = runner.ensureBoolean(value, this.getHandledNodeType(), ATTR_IGNORE_CASE, orig);
        }
        if (TYPE_REGEX.equals(type)) {
            Pattern p = runner.getPattern(this.getHandledNodeType(), delim, origDelim, ATTR_DELIM, ignoreCase, contract);
            String[] tokens = p.split(toSplit);
            this.handleTokenize(tokens, prefix, session, countVar);
        } else if (TYPE_TEXT.equals(type)) {
            String quoteDelim = Pattern.quote(delim);
            Pattern p = runner.getPattern(this.getHandledNodeType(), quoteDelim, origDelim, ATTR_DELIM, ignoreCase, contract);
            String[] tokens = p.split(toSplit);
            this.handleTokenize(tokens, prefix, session, countVar);
        }
        return new DefaultNodeHandlerResults();
    }

    private int handleTokenize(String[] tokens, String prefix, ContractSession session, String countVar) {
        int count = tokens == null ? 0 : tokens.length;
        for (int i = 0; i < count; ++i) {
            String tokenVar = prefix + i;
            session.setVariableValue(tokenVar, tokens[i]);
        }
        if (countVar != null) {
            session.setVariableValue(countVar, "" + count);
        }
        return count;
    }

    protected static final boolean isValidDelimType(String type) {
        boolean valid = false;
        if (type != null) {
            valid = TYPE_REGEX.equals(type) || TYPE_TEXT.equals(type);
        }
        return valid;
    }
}

