/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.ExpressionParser;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class SetNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "set";
    private static final String ATTR_EVAL = "eval";
    private static final String ATTR_IF_NULL = "ifNull";
    private static final String ATTR_VALUE = "value";

    public SetNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    private void ensureBothDontHaveValues(ContractRunner runner, File contract, String str1, String str2) throws InvalidContractException {
        if (str1 != null && str2 != null) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.SpecifyOnlyOne.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), "value/eval");
            throw new InvalidContractException(desc, contract);
        }
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String ifNull;
        boolean temp;
        String orig = node.getAttributeValue("name");
        if (orig == null) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.AttributeMissing.fmt.txt");
            desc = MessageFormat.format(desc, "name", this.getHandledNodeType());
            throw new ContractSyntaxException(desc, contract);
        }
        String varName = session.replaceVariables(orig);
        if (!DProUtil.isValidWritableVariableName(varName)) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.InvalidWritableVarName.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), orig, varName);
            throw new InvalidContractException(desc, contract);
        }
        String origValueValue = node.getAttributeValue(ATTR_VALUE);
        String origEvalValue = node.getAttributeValue(ATTR_EVAL);
        this.ensureBothDontHaveValues(runner, contract, origValueValue, origEvalValue);
        String varValue = null;
        if (origValueValue != null) {
            varValue = session.replaceVariables(origValueValue);
        } else if (origEvalValue != null) {
            String test = origEvalValue;
            varValue = "" + ExpressionParser.getInstance().parseIntegerExpression(test, this.getHandledNodeType(), session);
        } else {
            String origTextValue = node.getText();
            varValue = session.replaceVariables(origTextValue);
        }
        boolean doSet = true;
        orig = node.getAttributeValue(ATTR_IF_NULL);
        if (orig != null && (temp = runner.ensureBoolean(ifNull = session.replaceVariables(orig), this.getHandledNodeType(), ATTR_IF_NULL, orig))) {
            boolean bl = doSet = session.getVariableValue(varName) == null;
        }
        if (doSet && (orig = node.getAttributeValue("if")) != null) {
            String condition = orig;
            doSet = ExpressionParser.getInstance().parseBooleanExpression(condition, this.getHandledNodeType(), session);
        }
        if (doSet) {
            try {
                session.setVariableValue(varName, varValue);
            }
            catch (UnsupportedOperationException uoe) {
                throw new NodeHandlerException(uoe);
            }
        }
        return new DefaultNodeHandlerResults();
    }
}

