/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.ErrorInfo;
import com.sas.dpro.common.ErrorInfoImpl;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.Macro;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.RunActionFailedException;
import com.sas.dpro.contract.messages.ContractCompletedMessage;
import com.sas.dpro.contract.messages.ContractCompletedMessageImpl;
import com.sas.dpro.contract.messages.Message;
import com.sas.dpro.contract.messages.ResultsMessage;
import com.sas.dpro.contract.messages.RunActionCompletedMessageImpl;
import com.sas.dpro.contract.messages.RunActionStartedMessageImpl;
import com.sas.dpro.contract.messages.RunContractCompletedMessageImpl;
import com.sas.dpro.contract.messages.RunContractMessageImpl;
import com.sas.dpro.contract.messages.ServiceCompletedMessage;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.HonorContractContext;
import com.sas.dpro.controller.HonorContractParmsImpl;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jdom2.Element;

public class RunNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "run";
    public static final String TYPE_FILE_LIST = "fileList";
    public static final String TYPE_FILE_LISTS = "fileLists";
    public static final String TYPE_FILE_SET = "fileSet";
    public static final String TYPE_FILE_SETS = "fileSets";
    public static final String TYPE_MACRO = "macro";
    public static final String TYPE_MACROS = "macros";
    public static final String TYPE_VAR = "var";
    public static final String TYPE_VARS = "vars";
    private static final String ATTR_CONTRACT_CONTAINER = "contractContainer";
    private static final String ATTR_CONTRACT_INDEX_VAR = "contractIndexVar";
    private static final String ATTR_CONTRACT_TOTAL_VAR = "contractTotalVar";
    private static final String ATTR_FAIL_IF_NO_CONTRACTS = "failIfNothingToRun";
    private static final String ATTR_MAX_ERROR_COUNT = "maxErrorCount";
    private static final String ATTR_PARALLEL_COUNT = "parallelCount";
    private static final String ATTR_PREFIX = "prefix";
    private static final String ATTR_THREAD_PRIORITY = "threadPriority";
    private static final String ATTR_TIMEOUT = "timeOut";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VAR_APPEND = "append";
    private static final String PARAM_CONTRACT = "contract";
    private static final String PARAM_CONTRACTS = "contracts";
    private static final String PARAM_CONTRACT_LIST_FILE = "contractListFile";
    private static final String PARAM_EXPORTED_FILE_LIST = "fileList";
    private static final String PARAM_EXPORTED_FILE_LISTS = "fileLists";
    private static final String PARAM_EXPORTED_FILE_SET = "fileSet";
    private static final String PARAM_EXPORTED_FILE_SETS = "fileSets";
    private static final String PARAM_EXPORTED_MACRO = "macro";
    private static final String PARAM_EXPORTED_MACROS = "macros";
    private static final String PARAM_EXPORTS = "exports";
    private static final String PARAM_IMPORT = "import";
    private static final String PARAM_IMPORTS = "imports";
    private static final String PARAM_INITIAL_CONTRACT_VARS = "initialContractVars";
    private static final String ERROR_MSG = "com.sas.dpro.contract.parser.RunNodeHandler";
    private static final boolean DEFAULT_IMPORT = false;
    private static final int DEFAULT_MAX_ERROR_COUNT = 0;
    private static final int DEFAULT_PARALLEL_COUNT = 3;
    private static final int DEFAULT_THREAD_PRIORITY = 1;
    private static final String PROPERTY_DEBUG = "com.sas.dpro.contract.parser.RunNodeHandler.debug";

    public RunNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    private FileList[] createDeepCopy(FileList[] orig) {
        FileList[] array = null;
        if (orig != null && orig.length > 0) {
            array = new FileList[orig.length];
            for (int i = 0; i < orig.length; ++i) {
                try {
                    array[i] = (FileList)orig[i].clone();
                    continue;
                }
                catch (CloneNotSupportedException cnse) {
                    cnse.printStackTrace();
                }
            }
        }
        return array;
    }

    private FileSet[] createDeepCopy(FileSet[] orig) {
        FileSet[] array = null;
        if (orig != null && orig.length > 0) {
            array = new FileSet[orig.length];
            for (int i = 0; i < orig.length; ++i) {
                try {
                    array[i] = (FileSet)orig[i].clone();
                    continue;
                }
                catch (CloneNotSupportedException cnse) {
                    cnse.printStackTrace();
                }
            }
        }
        return array;
    }

    private Macro[] createDeepCopy(Macro[] orig) {
        Macro[] array = null;
        if (orig != null && orig.length > 0) {
            array = new Macro[orig.length];
            for (int i = 0; i < orig.length; ++i) {
                try {
                    array[i] = (Macro)orig[i].clone();
                    continue;
                }
                catch (CloneNotSupportedException cnse) {
                    cnse.printStackTrace();
                }
            }
        }
        return array;
    }

    private void debugMsg(String msg) {
        if (Boolean.getBoolean(PROPERTY_DEBUG)) {
            System.err.println("[RunNodeHandler DEBUG]: " + msg);
        }
    }

    protected ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(ERROR_MSG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List handleContractsNode(Element node, ContractRunner runner, ContractSession session, File contract) throws InvalidContractException, IOException {
        ArrayList<Object> contractsToRun = new ArrayList<Object>();
        for (Element child : node.getChildren()) {
            String orig;
            String orig2;
            ContainerContext cc;
            String childName = child.getName();
            if (PARAM_CONTRACT.equals(childName)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                cc = session.getDefaultContainer();
                orig2 = child.getAttributeValue("container");
                if (orig2 != null) {
                    cc = this.getContainerContextChecked(orig2, session, runner, contract);
                }
                String contractToRun = child.getText();
                contractToRun = session.replaceVariables(contractToRun);
                contractsToRun.add(new ContainerContractPair(cc, contractToRun));
                continue;
            }
            if (PARAM_CONTRACT_LIST_FILE.equals(childName)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                cc = session.getDefaultContainer();
                orig2 = child.getAttributeValue("container");
                if (orig2 != null) {
                    cc = this.getContainerContextChecked(orig2, session, runner, contract);
                }
                ContainerContext contractCC = session.getDefaultContainer();
                orig2 = child.getAttributeValue(ATTR_CONTRACT_CONTAINER);
                if (orig2 != null) {
                    contractCC = this.getContainerContextChecked(orig2, session, runner, contract);
                }
                String listFile = child.getText();
                listFile = session.replaceVariables(listFile);
                InputStream in = DProUtil.getFileContents(cc, listFile);
                String charset = child.getAttributeValue("characterSet");
                Charset cs = (charset = session.replaceVariables(charset)) == null ? Charset.defaultCharset() : Charset.forName(charset);
                BufferedReader r = new BufferedReader(new InputStreamReader(in, cs));
                try {
                    String line = null;
                    while ((line = r.readLine()) != null) {
                        if (line.length() <= 0 || line.startsWith("#")) continue;
                        contractsToRun.add(new ContainerContractPair(contractCC, line));
                    }
                    continue;
                }
                finally {
                    r.close();
                    continue;
                }
            }
            if ("fileListRef".equals(childName)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                orig = child.getAttributeValue("refId");
                FileList fl = this.getFileListChecked(orig, session, runner, contract, true);
                for (int j = 0; j < fl.getSize(); ++j) {
                    contractsToRun.add(new ProviderContractPair(fl.getProvider(), fl.getAbsolute(j)));
                }
                continue;
            }
            if (!"fileSetRef".equals(childName) || !this.checkIfAttribute(child, session, contract)) continue;
            orig = child.getAttributeValue("refId");
            FileSet fs = this.getFileSetChecked(orig, session, runner, contract, true);
            FileList fl = fs.getMatchingFiles();
            for (int j = 0; j < fl.getSize(); ++j) {
                contractsToRun.add(new ProviderContractPair(fl.getProvider(), fl.getAbsolute(j)));
            }
        }
        return contractsToRun;
    }

    protected List handleContractVarsNode(Element node, ContractRunner runner, ContractSession session, File contract) throws InvalidContractException, IOException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return null;
        }
        boolean doAppend = false;
        String orig = node.getAttributeValue(ATTR_VAR_APPEND);
        if (orig != null) {
            String append = session.replaceVariables(orig);
            doAppend = runner.ensureBoolean(append, this.getHandledNodeType(), ATTR_VAR_APPEND, orig);
        }
        ArrayList<String> contractVarList = new ArrayList<String>();
        if (doAppend) {
            Map toAppend = session.createVariableMap();
            for (Map.Entry entry : toAppend.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                contractVarList.add(key);
                contractVarList.add(value);
            }
        }
        this.parseVarList(node, runner, session, contract, contractVarList);
        if (contractVarList.size() == 0) {
            return null;
        }
        return contractVarList;
    }

    public void handleExportsNode(Element node, ContractRunner runner, ContractSession session, File contract, List exportedFileLists, List exportedFileSets, List exportedMacros) throws IOException, InvalidContractException {
        for (Element child : node.getChildren()) {
            String orig;
            String name;
            String childName = child.getName();
            if ("fileLists".equals(childName)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                for (Element e : child.getChildren()) {
                    name = e.getName();
                    if ("fileList".equals(name) && !this.checkIfAttribute(e, session, contract)) continue;
                    orig = e.getAttributeValue("refId");
                    FileList fl = this.getFileListChecked(orig, session, runner, contract, true);
                    exportedFileLists.add(fl);
                }
            }
            if ("fileSets".equals(childName)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                for (Element e : child.getChildren()) {
                    name = e.getName();
                    if ("fileSet".equals(name) && !this.checkIfAttribute(e, session, contract)) continue;
                    orig = e.getAttributeValue("refId");
                    FileSet fs = this.getFileSetChecked(orig, session, runner, contract, true);
                    exportedFileSets.add(fs);
                }
                continue;
            }
            if (!"macros".equals(childName) || !this.checkIfAttribute(child, session, contract)) continue;
            for (Element e : child.getChildren()) {
                name = e.getName();
                if (!"macro".equals(name) || !this.checkIfAttribute(e, session, contract)) continue;
                orig = e.getAttributeValue("refId");
                Macro m = this.getMacroChecked(orig, session, runner, contract, true);
                exportedMacros.add(m);
            }
        }
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        int contractCount;
        String priorityStr;
        long timeout = -1L;
        String orig = node.getAttributeValue(ATTR_TIMEOUT);
        if (orig != null) {
            String timeoutStr = session.replaceVariables(orig);
            try {
                timeout = Long.parseLong(timeoutStr);
                if (timeout != -1L && timeout < 0L) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfe) {
                ResourceBundle msg = this.getErrorBundle();
                String desc = msg.getString("Error.InvalidTimeout.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), orig, timeoutStr);
                throw new InvalidContractException(desc, contract, nfe);
            }
        }
        int poolSize = 3;
        orig = node.getAttributeValue(ATTR_PARALLEL_COUNT);
        if (orig != null) {
            String poolSizeStr = session.replaceVariables(orig);
            try {
                poolSize = Integer.parseInt(poolSizeStr);
                if (poolSize == 0) {
                    poolSize = Integer.MAX_VALUE;
                } else if (poolSize < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfe) {
                ResourceBundle msg = this.getErrorBundle();
                String desc = msg.getString("Error.InvalidParallel.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), orig, poolSizeStr);
                throw new InvalidContractException(desc, contract, nfe);
            }
        }
        int threadPriority = 1;
        orig = node.getAttributeValue(ATTR_THREAD_PRIORITY);
        if (orig != null && !"default".equals(priorityStr = session.replaceVariables(orig))) {
            if ("min".equals(priorityStr)) {
                threadPriority = 1;
            } else if ("norm".equals(priorityStr) || "normal".equals(priorityStr)) {
                threadPriority = 5;
            } else if ("max".equals(priorityStr)) {
                threadPriority = 10;
            } else {
                ResourceBundle msg = this.getErrorBundle();
                String desc = msg.getString("Error.InvalidThreadPriority.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), orig, priorityStr);
                throw new InvalidContractException(desc, contract);
            }
        }
        int maxErrorCount = 0;
        orig = node.getAttributeValue(ATTR_MAX_ERROR_COUNT);
        if (orig != null) {
            String errorCountStr = session.replaceVariables(orig);
            try {
                maxErrorCount = Integer.parseInt(errorCountStr);
                if (maxErrorCount < 0) {
                    maxErrorCount = Integer.MAX_VALUE;
                }
            }
            catch (NumberFormatException nfe) {
                ResourceBundle msg = this.getErrorBundle();
                String desc = msg.getString("Error.InvalidMaxErrorCount.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), orig, errorCountStr);
                throw new InvalidContractException(desc, contract, nfe);
            }
        }
        String indexVarName = null;
        orig = node.getAttributeValue(ATTR_CONTRACT_INDEX_VAR);
        if (orig != null) {
            indexVarName = this.getVariableNameChecked(orig, false, session, runner, contract);
        }
        String totalVarName = null;
        orig = node.getAttributeValue(ATTR_CONTRACT_TOTAL_VAR);
        if (orig != null) {
            totalVarName = this.getVariableNameChecked(orig, false, session, runner, contract);
        }
        List contractsToRun = null;
        List contractVarList = null;
        ArrayList exportedFileLists = null;
        ArrayList exportedFileSets = null;
        ArrayList exportedMacros = null;
        boolean importFileLists = false;
        String importedFileListPrefix = null;
        boolean importFileSets = false;
        String importedFileSetPrefix = null;
        boolean importMacros = false;
        String importedMacroPrefix = null;
        boolean importVars = false;
        String importedVarPrefix = null;
        for (Element child : node.getChildren()) {
            String childName = child.getName();
            if (PARAM_CONTRACTS.equals(childName)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                contractsToRun = this.handleContractsNode(child, runner, session, contract);
                continue;
            }
            if (PARAM_EXPORTS.equals(childName)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                if (exportedMacros == null) {
                    exportedFileLists = new ArrayList(1);
                    exportedFileSets = new ArrayList(1);
                    exportedMacros = new ArrayList(1);
                }
                this.handleExportsNode(child, runner, session, contract, exportedFileLists, exportedFileSets, exportedMacros);
                continue;
            }
            if (PARAM_INITIAL_CONTRACT_VARS.equals(childName)) {
                contractVarList = this.handleContractVarsNode(child, runner, session, contract);
                continue;
            }
            if (!PARAM_IMPORTS.equals(childName) || !this.checkIfAttribute(child, session, contract)) continue;
            for (Element e : child.getChildren()) {
                String eName = e.getName();
                if (!PARAM_IMPORT.equals(eName) || !this.checkIfAttribute(e, session, contract)) continue;
                String origType = e.getAttributeValue(ATTR_TYPE);
                String type = session.replaceVariables(origType);
                String prefix = null;
                orig = e.getAttributeValue(ATTR_PREFIX);
                if (orig != null) {
                    prefix = session.replaceVariables(orig);
                }
                if ("fileList".equals(type) || "fileLists".equals(type)) {
                    importFileLists = true;
                    importedFileListPrefix = prefix;
                    continue;
                }
                if ("fileSet".equals(type) || "fileSets".equals(type)) {
                    importFileSets = true;
                    importedFileSetPrefix = prefix;
                    continue;
                }
                if ("macro".equals(type) || "macros".equals(type)) {
                    importMacros = true;
                    importedMacroPrefix = prefix;
                    continue;
                }
                if (TYPE_VAR.equals(type) || TYPE_VARS.equals(type)) {
                    importVars = true;
                    importedVarPrefix = prefix;
                    continue;
                }
                ResourceBundle msg = this.getErrorBundle();
                String desc = msg.getString("Error.InvalidImportType.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), type, origType);
                throw new InvalidContractException(desc, contract);
            }
        }
        int n = contractCount = contractsToRun == null ? 0 : contractsToRun.size();
        if (contractCount == 0) {
            boolean failIfNoContracts = true;
            orig = node.getAttributeValue(ATTR_FAIL_IF_NO_CONTRACTS);
            if (orig != null) {
                String value = session.replaceVariables(orig);
                failIfNoContracts = runner.ensureBoolean(value, this.getHandledNodeType(), ATTR_FAIL_IF_NO_CONTRACTS, orig);
            }
            if (failIfNoContracts) {
                ResourceBundle msg = this.getErrorBundle();
                String desc = msg.getString("Error.NoContracts.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType());
                throw new InvalidContractException(desc, contract);
            }
        }
        FileList[] fileLists = null;
        if (exportedFileLists != null && exportedFileLists.size() > 0) {
            fileLists = new FileList[exportedFileLists.size()];
            fileLists = exportedFileLists.toArray(fileLists);
        }
        FileSet[] fileSets = null;
        if (exportedFileSets != null && exportedFileSets.size() > 0) {
            fileSets = new FileSet[exportedFileSets.size()];
            fileSets = exportedFileSets.toArray(fileSets);
        }
        Macro[] macros = null;
        if (exportedMacros != null && exportedMacros.size() > 0) {
            macros = new Macro[exportedMacros.size()];
            macros = exportedMacros.toArray(macros);
        }
        return this.runContracts(runner, session, contractsToRun, timeout, poolSize, threadPriority, contractVarList, macros, fileLists, fileSets, maxErrorCount, importFileLists, importedFileListPrefix, importFileSets, importedFileSetPrefix, importMacros, importedMacroPrefix, importVars, importedVarPrefix, indexVarName, totalVarName);
    }

    protected NodeHandlerResults runContracts(ContractRunner runner, ContractSession session, List contractsToRun, long timeout, int poolSize, int threadPriority, List vars, Macro[] macros, FileList[] fileLists, FileSet[] fileSets, int maxErrorCount, boolean importFileLists, String importedFileListPrefix, boolean importFileSets, String importedFileSetPrefix, boolean importMacros, String importedMacroPrefix, boolean importVars, String importVarPrefix, String indexVarName, String totalVarName) throws IOException, NodeHandlerException, InvalidContractException {
        int contractCount = contractsToRun == null ? 0 : contractsToRun.size();
        RunActionStartedMessageImpl rasmi = new RunActionStartedMessageImpl(session.getHonorContractContext(), contractCount);
        session.getMessageQueue().enqueue(rasmi);
        DefaultNodeHandlerResults nhr = new DefaultNodeHandlerResults();
        if (contractCount == 0) {
            this.debugMsg("RunNodeHandler.runContract: No contracts to run! Exiting...");
            RunActionCompletedMessageImpl racmi = new RunActionCompletedMessageImpl(session.getHonorContractContext());
            racmi.setContractInfo(contractCount, 0, 0, 0);
            session.getMessageQueue().enqueue(racmi);
            return nhr;
        }
        this.debugMsg("RunNodeHandler.runContract: Creating Executor");
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        Executor executor = new Executor(queue, poolSize, threadPriority, session, maxErrorCount, importFileLists, importedFileListPrefix, importFileSets, importedFileSetPrefix, importMacros, importedMacroPrefix, importVars, importVarPrefix);
        if (totalVarName != null) {
            if (vars == null) {
                vars = new ArrayList<String>(4);
            }
            vars.add(totalVarName);
            vars.add("" + contractCount);
        }
        String lastProvider = null;
        Provider p = null;
        for (int i = 0; i < contractCount; ++i) {
            String provider;
            String contract = null;
            Object obj = contractsToRun.get(i);
            if (obj instanceof ProviderContractPair) {
                ProviderContractPair pcp = (ProviderContractPair)obj;
                provider = pcp.provider;
                if (provider == null) {
                    provider = "server-local";
                }
                if (!provider.equals(lastProvider)) {
                    p = ProviderFactory.getProvider(provider);
                }
                lastProvider = provider;
                contract = pcp.contract;
            } else {
                ContainerContractPair ccp = (ContainerContractPair)obj;
                provider = ccp.cont.getProviderName();
                if (provider == null) {
                    provider = "server-local";
                }
                if (!provider.equals(lastProvider)) {
                    p = ProviderFactory.getProvider(provider);
                }
                lastProvider = provider;
                contract = p.getAbsoluteFilePath(ccp.cont, ccp.contract);
            }
            ArrayList<String> temp = vars;
            if (indexVarName != null) {
                temp = vars != null ? new ArrayList(vars) : new ArrayList();
                temp.add(indexVarName);
                temp.add("" + (i + 1));
            }
            String[] varArray = null;
            if (temp != null && temp.size() > 0) {
                varArray = new String[temp.size()];
                varArray = temp.toArray(varArray);
            }
            FileList[] fl2 = this.createDeepCopy(fileLists);
            FileSet[] fs2 = this.createDeepCopy(fileSets);
            Macro[] macros2 = this.createDeepCopy(macros);
            RunThread r = new RunThread(p, runner, session, contract, timeout, varArray, macros2, fl2, fs2);
            this.debugMsg("RunNodeHandler.runContract: Adding contract " + i + " to run queue: " + r);
            executor.execute(r);
        }
        this.debugMsg("RunNodeHandler.runContract: All " + contractsToRun.size() + " contracts added to Executor");
        this.debugMsg("RunNodeHandler.runContract: Moving session to 'paused' queue");
        session.initWait();
        session.pause();
        executor.shutdown();
        this.debugMsg("RunNodeHandler.runContract: Calling session.beginWait()");
        try {
            session.beginWait();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            executor.shutdownNow();
            nhr.setStopContract(true);
            HonorContractContext hcc = session.getHonorContractContext();
            ContractCompletedMessageImpl ccmi = new ContractCompletedMessageImpl(hcc);
            String pName = hcc.getProviderName();
            if (pName == null) {
                pName = ProviderFactory.getLocalProviderName();
            }
            ErrorInfoImpl ei = new ErrorInfoImpl(pName, ie);
            ccmi.setErrorInfo(ei);
            nhr.setStoppedContractCompletedMessage(ccmi);
            this.debugMsg("RunNodeHandler.runContract: session.beginWait() interrupted! Terminating early");
            return nhr;
        }
        this.debugMsg("RunNodeHandler.runContract: session.beginWait() completed");
        int completedCount = executor.completedCount;
        int timeoutCount = executor.timeoutCount;
        int errorCount = executor.errorCount;
        if (executor.getTooManyErrors()) {
            HonorContractContext hcc = session.getHonorContractContext();
            ContractCompletedMessageImpl ccmi = new ContractCompletedMessageImpl(hcc);
            ResourceBundle msg = this.getErrorBundle();
            String desc = msg.getString("Error.TooManyErrors.fmt.txt");
            String contract = session.getContractName();
            if (contract == null) {
                contract = msg.getString("NoContractFile.txt");
            }
            desc = MessageFormat.format(desc, this.getHandledNodeType(), ProviderFactory.getLocalProviderName(), contract, new Long(executor.getTaskCount()), new Integer(completedCount), new Integer(errorCount + timeoutCount));
            RunActionFailedException t = new RunActionFailedException(desc);
            t.setContractInfo(contractCount, completedCount, errorCount, timeoutCount);
            t.setContractCompletedMessages(executor.getCCMs());
            String server = hcc.getProviderName();
            if (server == null) {
                server = "server-local";
            }
            ErrorInfoImpl ei = new ErrorInfoImpl(server, t);
            ccmi.setErrorInfo(ei);
            nhr.setStopContract(true);
            nhr.setStoppedContractCompletedMessage(ccmi);
        }
        this.debugMsg("RunNodeHandler.runContract: submittedCount==" + executor.getTaskCount());
        this.debugMsg("RunNodeHandler.runContract: completedCount==" + completedCount);
        this.debugMsg("RunNodeHandler.runContract: timeoutCount==" + timeoutCount);
        this.debugMsg("RunNodeHandler.runContract: errorCount==" + errorCount);
        this.debugMsg("RunNodeHandler.runContract: tooManyErrors==" + executor.getTooManyErrors());
        RunActionCompletedMessageImpl racmi = new RunActionCompletedMessageImpl(session.getHonorContractContext());
        racmi.setContractInfo(contractCount, completedCount, errorCount, timeoutCount);
        session.getMessageQueue().enqueue(racmi);
        return nhr;
    }

    private static class ContainerContractPair {
        public ContainerContext cont;
        public String contract;

        public ContainerContractPair(ContainerContext cc, String contract) {
            this.cont = cc;
            this.contract = contract;
        }
    }

    private static class ProviderContractPair {
        public String provider;
        public String contract;

        public ProviderContractPair(String provider, String contract) {
            this.provider = provider;
            this.contract = contract;
        }
    }

    class Executor
    extends ThreadPoolExecutor {
        private List resultsList;
        private int threadPriority;
        private ContractSession session;
        private int errorCount;
        private int timeoutCount;
        private int completedCount;
        private int maxErrorCount;
        private boolean importFileLists;
        private boolean importFileSets;
        private String importedFileListPrefix;
        private String importedFileSetPrefix;
        private boolean importMacros;
        private String importedMacroPrefix;
        private boolean importVars;
        private String importedVarPrefix;
        private boolean terminated;

        public Executor(BlockingQueue queue, int poolSize, int threadPriority, ContractSession session, int maxErrorCount, boolean importFileLists, String importedFileListPrefix, boolean importFileSets, String importedFileSetPrefix, boolean importMacros, String importedMacroPrefix, boolean importVars, String importedVarPrefix) {
            super(poolSize, poolSize, 10L, TimeUnit.SECONDS, queue);
            this.resultsList = new ArrayList(1);
            this.threadPriority = threadPriority;
            this.session = session;
            this.timeoutCount = 0;
            this.errorCount = 0;
            this.completedCount = 0;
            this.maxErrorCount = maxErrorCount;
            this.importFileLists = importFileLists;
            this.importedFileListPrefix = importedFileListPrefix;
            this.importFileSets = importFileSets;
            this.importedFileSetPrefix = importedFileSetPrefix;
            this.importMacros = importMacros;
            this.importedMacroPrefix = importedMacroPrefix;
            this.importVars = importVars;
            this.importedVarPrefix = importedVarPrefix;
        }

        @Override
        protected synchronized void afterExecute(Runnable r, Throwable t) {
            int i;
            ContainerContext[] leftOpen;
            super.afterExecute(r, t);
            RunThread rt = (RunThread)r;
            RunNodeHandler.this.debugMsg("Executor.afterExecute: " + rt);
            RunThreadResults results = rt.getResults();
            this.resultsList.add(results);
            if (results == null) {
                ++this.errorCount;
                RunNodeHandler.this.debugMsg("Executor.afterExecute: ... no results!");
                if (this.getTooManyErrors()) {
                    RunNodeHandler.this.debugMsg("Executor.afterExecute: Too many errors; shutting down");
                    this.shutdownNow();
                }
                return;
            }
            ++this.completedCount;
            ContractCompletedMessage ccm = results.ccm;
            if (ccm.isError()) {
                ++this.errorCount;
                RunNodeHandler.this.debugMsg("Executor.afterExecute: ... error!");
                ErrorInfo ei = ccm.getErrorInfo();
                if (ei == null) {
                    RunNodeHandler.this.debugMsg("Executor.afterExecute: ... ... No error info");
                } else {
                    String stackTrace = ei.getErrorStackTrace();
                    RunNodeHandler.this.debugMsg("Executor.afterExecute: ... ... Error stack trace:\n" + stackTrace);
                }
                if (this.getTooManyErrors()) {
                    RunNodeHandler.this.debugMsg("Executor.afterExecute: Too many errors; shutting down");
                    this.shutdownNow();
                }
            }
            if (ccm.isTimeout()) {
                ++this.timeoutCount;
                RunNodeHandler.this.debugMsg("Executor.afterExecute: ... timeout!");
                if (this.getTooManyErrors()) {
                    RunNodeHandler.this.debugMsg("Executor.afterExecute: Too many errors; shutting down");
                    this.shutdownNow();
                }
            }
            int count = (leftOpen = ccm.getLeftOpenContainers()) == null ? 0 : leftOpen.length;
            for (int i2 = 0; i2 < count; ++i2) {
                this.session.addContainerContext(leftOpen[i2]);
            }
            if (this.importFileLists) {
                FileList[] importedFileLists = ccm.getImportableFileLists();
                count = importedFileLists == null ? 0 : importedFileLists.length;
                for (i = 0; i < count; ++i) {
                    if (importedFileLists[i] == null) continue;
                    FileList fl = (FileList)importedFileLists[i].createCopy(this.importedFileListPrefix);
                    this.session.addFileList(fl);
                }
            }
            if (this.importFileSets) {
                FileSet[] importedFileSets = ccm.getImportableFileSets();
                count = importedFileSets == null ? 0 : importedFileSets.length;
                for (i = 0; i < count; ++i) {
                    if (importedFileSets[i] == null) continue;
                    FileSet fs = (FileSet)importedFileSets[i].createCopy(this.importedFileSetPrefix);
                    this.session.addFileSet(fs);
                }
            }
            if (this.importMacros) {
                Macro[] importedMacros = ccm.getImportableMacros();
                count = importedMacros == null ? 0 : importedMacros.length;
                for (i = 0; i < count; ++i) {
                    if (importedMacros[i] == null) continue;
                    Macro m = null;
                    try {
                        m = (Macro)importedMacros[i].clone();
                    }
                    catch (CloneNotSupportedException cnse) {
                        cnse.printStackTrace();
                    }
                    if (this.importedMacroPrefix != null) {
                        m.addIDPrefix(this.importedMacroPrefix);
                    }
                    this.session.addMacro(m);
                }
            }
            if (this.importVars) {
                String[] importedVars = ccm.getImportableVars();
                count = importedVars == null ? 0 : importedVars.length;
                for (i = 0; i < count; ++i) {
                    String name;
                    int equals = importedVars[i].indexOf(61);
                    if (equals > -1) {
                        name = importedVars[i].substring(0, equals);
                        String value = importedVars[i].substring(equals + 1);
                        if (this.importedVarPrefix != null) {
                            name = this.importedVarPrefix + name;
                        }
                        this.session.setVariableValue(name, value);
                        continue;
                    }
                    name = importedVars[i];
                    if (this.importedVarPrefix != null) {
                        name = this.importedVarPrefix + name;
                    }
                    this.session.setVariableValue(name, null);
                }
            }
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            RunNodeHandler.this.debugMsg("Executor.beforeExecute: " + r);
            t.setName("RunNodeHandler-runThread-" + t.getName());
            t.setPriority(this.threadPriority);
            super.beforeExecute(t, r);
        }

        public ContractCompletedMessage[] getCCMs() {
            int count = this.resultsList.size();
            ContractCompletedMessage[] ccms = new ContractCompletedMessage[count];
            for (int i = 0; i < count; ++i) {
                RunThreadResults rtr = (RunThreadResults)this.resultsList.get(i);
                ccms[i] = rtr == null ? null : rtr.ccm;
            }
            return ccms;
        }

        public boolean getTooManyErrors() {
            return this.errorCount + this.timeoutCount > this.maxErrorCount;
        }

        @Override
        protected synchronized void terminated() {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
            super.terminated();
            RunNodeHandler.this.debugMsg("Executor.terminated");
            RunNodeHandler.this.debugMsg("Executor.terminated: Notifying main thread");
            this.session.unpause();
            RunNodeHandler.this.debugMsg("Executor.terminated: Done notifying main thread");
        }
    }

    static class RunThread
    implements Runnable {
        private ContractRunner runner;
        private ContractSession session;
        private String contract;
        private long timeout;
        private String[] vars;
        private FileList[] fileLists;
        private FileSet[] fileSets;
        private Macro[] macros;
        private Provider p;
        private RunThreadResults results;
        private boolean isError;

        public RunThread(Provider p, ContractRunner runner, ContractSession session, String contract, long timeout, String[] vars, Macro[] macros, FileList[] fileLists, FileSet[] fileSets) {
            this.p = p;
            this.runner = runner;
            this.session = session;
            this.contract = contract;
            this.timeout = timeout;
            this.vars = vars;
            this.fileLists = fileLists;
            this.fileSets = fileSets;
            this.macros = macros;
        }

        public boolean getHadError() {
            return this.isError;
        }

        public RunThreadResults getResults() {
            return this.results;
        }

        @Override
        public void run() {
            try {
                this.runImpl();
            }
            catch (Exception re) {
                this.isError = true;
                System.err.println("Unexpected error in RunThread#runImpl()! - ");
                re.printStackTrace();
            }
        }

        protected void runImpl() throws RemoteException {
            long originalSessionID = this.session.getHonorContractContext().getOriginalContractSessionID();
            HonorContractParmsImpl parms = new HonorContractParmsImpl();
            parms.setClientDPROVersion(this.runner.getClientDPROVersion());
            parms.setContract(this.contract);
            parms.setFileLists(this.fileLists);
            parms.setFileSets(this.fileSets);
            parms.setLocale(Locale.getDefault().getLanguage());
            parms.setMacros(this.macros);
            parms.setOriginalContractSessionID(originalSessionID);
            parms.setTimeout(this.timeout);
            parms.setVariables(this.vars);
            parms.setMessageGranularity(2);
            HonorContractContext runHcc = this.p.honorContract(parms);
            RunContractMessageImpl rcm = new RunContractMessageImpl(this.session.getHonorContractContext(), runHcc);
            this.session.getMessageQueue().enqueue(rcm);
            Message message = null;
            do {
                if ((message = this.p.poll(runHcc)) instanceof ResultsMessage) {
                    ResultsMessage rm = (ResultsMessage)message;
                    switch (rm.getType()) {
                        case 2: {
                            break;
                        }
                        default: {
                            this.session.getMessageQueue().enqueue(rm);
                            break;
                        }
                    }
                    continue;
                }
                if (message instanceof ServiceCompletedMessage) {
                    ServiceCompletedMessage scm = (ServiceCompletedMessage)message;
                    this.session.addServiceResults(scm);
                    continue;
                }
                if (message instanceof ContractCompletedMessage) continue;
                this.session.getMessageQueue().enqueue(message);
            } while (!(message instanceof ContractCompletedMessage));
            ContractCompletedMessage ccm = (ContractCompletedMessage)message;
            RunContractCompletedMessageImpl rccmi = new RunContractCompletedMessageImpl(this.session.getHonorContractContext(), runHcc);
            rccmi.setContractCompletedMessage(ccm);
            this.session.getMessageQueue().enqueue(rccmi);
            this.results = new RunThreadResults(ccm);
        }

        public String toString() {
            return "[RunThread: contract=" + this.contract + "]";
        }
    }

    static class RunThreadResults {
        public ContractCompletedMessage ccm;

        public RunThreadResults(ContractCompletedMessage ccm) {
            this.ccm = ccm;
        }
    }
}

