/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.messages.LoadReportMessageImpl;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.HonorContractContext;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;

public class LoadReportNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "loadReport";
    private static final String PARAM_FROM_DIR = "fromDir";
    private static final String PARAM_REPORT_ID = "reportID";
    private static final String PARAM_REPORT_TYPE = "reportType";

    public LoadReportNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return new DefaultNodeHandlerResults();
        }
        String orig = node.getAttributeValue(PARAM_REPORT_ID);
        String reportID = session.replaceVariables(orig);
        orig = node.getAttributeValue(PARAM_REPORT_TYPE);
        String reportType = session.replaceVariables(orig);
        String fromDir = null;
        for (Element child : node.getChildren()) {
            String childName = child.getName();
            if (!PARAM_FROM_DIR.equals(childName)) continue;
            orig = child.getText();
            fromDir = session.replaceVariables(orig);
        }
        HonorContractContext hcc = session.getHonorContractContext();
        LoadReportMessageImpl lrm = new LoadReportMessageImpl(hcc, fromDir, reportID, reportType);
        session.getMessageQueue().enqueue(lrm);
        return new DefaultNodeHandlerResults();
    }
}

