/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.ProviderNotAvailableException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class IsServiceAvailableNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "isServiceAvailable";
    private static final String ATTR_FAIL_IF_UNAVAILABLE = "failIfServerUnavailable";
    private static final String ATTR_SERVER = "server";
    private static final String PARAM_SERVICE = "Service";
    private static final String ATTR_VARIABLE = "variable";
    private static final String MSG = "com.sas.dpro.contract.parser.IsServiceAvailableNodeHandler";

    public IsServiceAvailableNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    private ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String var = node.getAttributeValue(ATTR_VARIABLE);
        var = this.getVariableNameChecked(var, false, session, runner, contract);
        String origServer = node.getAttributeValue(ATTR_SERVER);
        String server = session.replaceVariables(origServer);
        Provider p = null;
        try {
            p = ProviderFactory.getProvider(server);
        }
        catch (ProviderNotAvailableException pnae) {
            boolean failIfUnavailable = false;
            String orig = node.getAttributeValue(ATTR_FAIL_IF_UNAVAILABLE);
            if (orig != null) {
                String failStr = session.replaceVariables(orig);
                failIfUnavailable = runner.ensureBoolean(failStr, this.getHandledNodeType(), ATTR_FAIL_IF_UNAVAILABLE, orig);
            }
            if (failIfUnavailable) {
                ResourceBundle msg = this.getErrorBundle();
                String desc = msg.getString("Error.ServerNotAvailable.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), server);
                throw new InvalidContractException(desc, contract);
            }
            session.setVariableValue(var, "false");
            return new DefaultNodeHandlerResults();
        }
        ArrayList<String> serviceList = null;
        for (Element e : node.getChildren()) {
            String orig;
            String temp;
            String name = e.getName();
            if (!PARAM_SERVICE.equals(name)) continue;
            if (serviceList == null) {
                serviceList = new ArrayList<String>(1);
            }
            if ((temp = session.replaceVariables(orig = e.getText())).indexOf(59) == -1) {
                serviceList.add(temp);
                continue;
            }
            String[] serviceNames = temp.split(";");
            for (int j = 0; j < serviceNames.length; ++j) {
                serviceList.add(serviceNames[j]);
            }
        }
        String[] serviceNames = null;
        if (serviceList != null && serviceList.size() > 0) {
            serviceNames = new String[serviceList.size()];
            serviceNames = serviceList.toArray(serviceNames);
        }
        boolean available = p.getAreServicesAvailable(serviceNames);
        session.setVariableValue(var, "" + available);
        return new DefaultNodeHandlerResults();
    }
}

