/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.jdom2.Element;

public class IsIntegerNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "isInteger";
    private static final String ATTR_RESULT = "result";
    private static final String ATTR_VARIABLE = "variable";

    public IsIntegerNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String orig = node.getAttributeValue(ATTR_VARIABLE);
        String var = this.getVariableNameChecked(orig, false, session, runner, contract);
        String value = session.getVariableValue(var);
        String isInt = "false";
        try {
            Integer.parseInt(value);
            isInt = "true";
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        orig = node.getAttributeValue(ATTR_RESULT);
        String resVar = this.getVariableNameChecked(orig, false, session, runner, contract);
        session.setVariableValue(resVar, isInt);
        return new DefaultNodeHandlerResults();
    }
}

