/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InputPromptInfoImpl;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom2.Element;

public class InputNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "input";
    private static final String ATTR_ALLOW_CANCEL = "allowCancel";
    private static final String ATTR_ALLOW_EMPTY_INPUT = "allowEmptyInput";
    private static final String ATTR_CHOICE_DESC = "description";
    private static final String ATTR_CHOICE_TEXT = "text";
    private static final String ATTR_DIR_LIST_REF = "dirListRef";
    private static final String ATTR_DIR_SET_REF = "dirSetRef";
    private static final String ATTR_FILE_LIST_REF = "fileListRef";
    private static final String ATTR_FILE_SET_REF = "fileSetRef";
    private static final String ATTR_IF_NULL = "ifNull";
    private static final String ATTR_IGNORE_CASE = "ignoreCase";
    private static final String ATTR_TRIM_WHITESPACE = "trimWhitespace";
    private static final String ATTR_VARIABLE = "variable";
    private static final String PARAM_CHOICE = "choice";
    private static final String PARAM_CHOICES = "choices";
    private static final String PARAM_DESCRIPTION = "description";
    private static final String PARAM_INPUT_ERROR_MESSAGE = "errorMessage";
    private static final String PARAM_INPUT_FORMAT = "inputFormat";
    private static final String PARAM_PROMPT = "prompt";
    private static final String PARAM_VALIDATION = "validation";
    private static final String ERROR_MSG = "com.sas.dpro.contract.parser.InputNodeHandler";
    private static ResourceBundle errorMsg;

    public InputNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    private static synchronized ResourceBundle getErrorBundle() {
        if (errorMsg == null) {
            errorMsg = ResourceBundle.getBundle(ERROR_MSG);
        }
        return errorMsg;
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String input;
        boolean areChoices;
        String ifNull;
        boolean temp;
        if (session.getStartedRemotely()) {
            ResourceBundle msg = InputNodeHandler.getErrorBundle();
            String desc = msg.getString("InputInRemoteContract.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType());
            throw new InvalidContractException(desc, contract);
        }
        if (!this.checkIfAttribute(node, session, contract)) {
            return new DefaultNodeHandlerResults();
        }
        String orig = node.getAttributeValue(ATTR_VARIABLE);
        String varName = this.getVariableNameChecked(orig, false, session, runner, contract);
        orig = node.getAttributeValue(ATTR_IF_NULL);
        if (orig != null && (temp = runner.ensureBoolean(ifNull = session.replaceVariables(orig), this.getHandledNodeType(), ATTR_IF_NULL, orig)) && session.getVariableValue(varName) != null) {
            return new DefaultNodeHandlerResults();
        }
        boolean allowCancel = true;
        orig = node.getAttributeValue(ATTR_ALLOW_CANCEL);
        if (orig != null) {
            String temp2 = session.replaceVariables(orig);
            allowCancel = runner.ensureBoolean(temp2, this.getHandledNodeType(), ATTR_ALLOW_CANCEL, orig);
        }
        boolean trim = false;
        orig = node.getAttributeValue(ATTR_TRIM_WHITESPACE);
        if (orig != null) {
            String temp3 = session.replaceVariables(orig);
            trim = runner.ensureBoolean(temp3, this.getHandledNodeType(), ATTR_TRIM_WHITESPACE, orig);
        }
        boolean allowEmpty = false;
        orig = node.getAttributeValue(ATTR_ALLOW_EMPTY_INPUT);
        if (orig != null) {
            String temp4 = session.replaceVariables(orig);
            allowEmpty = runner.ensureBoolean(temp4, this.getHandledNodeType(), ATTR_ALLOW_EMPTY_INPUT, orig);
        }
        String prompt = null;
        String desc = null;
        Pattern fmtPattern = null;
        String inputErrorMsg = null;
        ArrayList<String> choicesList = null;
        ArrayList<String> choicesDescList = null;
        for (Element child : node.getChildren()) {
            String childName = child.getName();
            if ("description".equals(childName)) {
                desc = child.getText();
                desc = session.replaceVariables(desc);
                continue;
            }
            if (PARAM_PROMPT.equals(childName)) {
                prompt = child.getText();
                prompt = session.replaceVariables(prompt);
                continue;
            }
            if (PARAM_CHOICES.equals(childName)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                if (choicesList == null) {
                    choicesList = new ArrayList<String>(3);
                    choicesDescList = new ArrayList<String>(3);
                }
                for (Element child2 : child.getChildren()) {
                    childName = child2.getName();
                    if (PARAM_CHOICE.equals(childName)) {
                        if (!this.checkIfAttribute(child2, session, contract)) continue;
                        Element e = child2.getChild(ATTR_CHOICE_TEXT);
                        String choiceText = e.getText();
                        choiceText = session.replaceVariables(choiceText);
                        choicesList.add(choiceText);
                        e = child2.getChild("description");
                        if (e == null) {
                            choicesDescList.add(null);
                            continue;
                        }
                        String descText = e.getText();
                        descText = session.replaceVariables(descText);
                        choicesDescList.add(descText);
                        continue;
                    }
                    if (ATTR_DIR_LIST_REF.equals(childName)) {
                        int count = this.parseAddDirListContentsNode(child2, choicesList, session, runner, contract);
                        for (int k = 0; k < count; ++k) {
                            choicesDescList.add(null);
                        }
                        continue;
                    }
                    if (ATTR_DIR_SET_REF.equals(childName)) {
                        int count = this.parseAddDirSetContentsNode(child2, choicesList, session, runner, contract);
                        for (int k = 0; k < count; ++k) {
                            choicesDescList.add(null);
                        }
                        continue;
                    }
                    if (ATTR_FILE_LIST_REF.equals(childName)) {
                        int count = this.parseAddFileListContentsNode(child2, choicesList, session, runner, contract);
                        for (int k = 0; k < count; ++k) {
                            choicesDescList.add(null);
                        }
                        continue;
                    }
                    if (!ATTR_FILE_SET_REF.equals(childName)) continue;
                    int count = this.parseAddFileSetContentsNode(child2, choicesList, session, runner, contract);
                    for (int k = 0; k < count; ++k) {
                        choicesDescList.add(null);
                    }
                }
                continue;
            }
            if (!PARAM_VALIDATION.equals(childName)) continue;
            for (Element e : child.getChildren()) {
                String temp5 = e.getName();
                if (PARAM_INPUT_FORMAT.equals(temp5)) {
                    String ignore;
                    boolean b;
                    orig = e.getText();
                    if (orig == null) continue;
                    String fmtStr = session.replaceVariables(orig);
                    int flags = 0;
                    orig = e.getAttributeValue(ATTR_IGNORE_CASE);
                    if (orig != null && (b = runner.ensureBoolean(ignore = session.replaceVariables(orig), this.getHandledNodeType(), ATTR_IGNORE_CASE, orig))) {
                        flags = 66;
                    }
                    try {
                        fmtPattern = Pattern.compile(fmtStr, flags);
                        continue;
                    }
                    catch (PatternSyntaxException pse) {
                        ResourceBundle msg = InputNodeHandler.getErrorBundle();
                        String text = msg.getString("InvalidRegex.fmt.txt");
                        text = MessageFormat.format(text, this.getHandledNodeType(), fmtStr, orig, pse.getMessage());
                        throw new InvalidContractException(text, contract);
                    }
                }
                if (!PARAM_INPUT_ERROR_MESSAGE.equals(temp5) || (orig = e.getText()) == null) continue;
                inputErrorMsg = session.replaceVariables(orig);
            }
        }
        boolean bl = areChoices = choicesList != null && choicesList.size() > 0;
        if (prompt == null) {
            String key = areChoices ? "DefaultPrompt.Choices.txt" : "DefaultPrompt.NoChoices.txt";
            prompt = InputNodeHandler.getErrorBundle().getString(key);
        }
        InputPromptInfoImpl info = new InputPromptInfoImpl(desc, prompt);
        info.setAllowCancelInput(allowCancel);
        info.setAllowEmptyInput(allowEmpty);
        info.setInputErrorMessage(inputErrorMsg);
        info.setInputFormat(fmtPattern);
        info.setTrimWhitespace(trim);
        String[] choices = null;
        if (areChoices) {
            choices = new String[choicesList.size()];
            choices = choicesList.toArray(choices);
            String[] descs = new String[choicesDescList.size()];
            descs = choicesDescList.toArray(descs);
            info.setChoices(choices, descs);
        }
        if ((input = session.promptForInput(info)) != null && trim && choices == null) {
            input = input.trim();
        }
        session.setVariableValue(varName, input);
        return new DefaultNodeHandlerResults();
    }
}

