/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.service.ServiceResults;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class GroovyNodeHandler
extends DefaultInternalServiceNodeHandler {
    public static final String ATTR_OUTPUT_VAR = "outputVar";
    private static final String MSG = "com.sas.dpro.contract.parser.GroovyNodeHandler";
    private static ResourceBundle msg;

    public GroovyNodeHandler() {
        super("Groovy");
    }

    private static synchronized ResourceBundle getGNHMessageBundle() {
        if (msg == null) {
            msg = ResourceBundle.getBundle(MSG);
        }
        return msg;
    }

    @Override
    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        boolean scriptFound = false;
        for (Element child : childNodeList) {
            String[] vars;
            String childName = child.getName();
            if ("script".equals(childName)) {
                if (scriptFound) {
                    this.handleMultipleScriptsSpecified(contract);
                }
                scriptFound = true;
                String script = child.getText();
                script = session.replaceVariables(script);
                params.put("script", script);
                String name = child.getAttributeValue("scriptName");
                if (name == null || (name = session.replaceVariables(name)) == null || name.length() <= 0) continue;
                params.put("scriptName", name);
                continue;
            }
            if ("scriptFile".equals(childName)) {
                if (scriptFound) {
                    this.handleMultipleScriptsSpecified(contract);
                }
                scriptFound = true;
                ContainerContext cc = session.getDefaultContainer();
                String orig = child.getAttributeValue("container");
                if (orig != null) {
                    cc = this.getContainerContextChecked(orig, session, runner, contract);
                }
                String scriptFile = child.getText();
                scriptFile = session.replaceVariables(scriptFile);
                String charset = child.getAttributeValue("characterSet");
                charset = session.replaceVariables(charset);
                params.put("_scriptFileContainer", cc);
                params.put("scriptFile", scriptFile);
                params.put("_scriptFileCharset", charset);
                continue;
            }
            if (!"initialVars".equals(childName) || (vars = this.handleInitialVarsNode(child, runner, session, contract)) == null) continue;
            params.put("initialVars", vars);
        }
        if (!scriptFound) {
            ResourceBundle msg = GroovyNodeHandler.getGNHMessageBundle();
            String key = "Error.NoScript.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getHandledNodeType());
            throw new InvalidContractException(desc, contract);
        }
    }

    @Override
    protected void handleExtra(Element node, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        String var = (String)params.get(ATTR_OUTPUT_VAR);
        if (var != null) {
            params.put("_saveOutput", "true");
        }
    }

    protected String[] handleInitialVarsNode(Element node, ContractRunner runner, ContractSession session, File contract) throws InvalidContractException, IOException {
        ArrayList list = new ArrayList();
        this.parseVarList(node, runner, session, contract, list);
        if (list.size() == 0) {
            return null;
        }
        String[] vars = new String[list.size()];
        vars = list.toArray(vars);
        return vars;
    }

    private void handleMultipleScriptsSpecified(File contract) throws InvalidContractException {
        ResourceBundle msg = GroovyNodeHandler.getGNHMessageBundle();
        String key = "Error.MultipleScripts.fmt.txt";
        String desc = DProUtil.formatString(msg, key, this.getHandledNodeType());
        throw new InvalidContractException(desc, contract);
    }

    @Override
    protected void postProcessing(ContractRunner runner, ContractSession session, File contract, SerializableMap params, DefaultNodeHandlerResults results) {
        String var = (String)params.get(ATTR_OUTPUT_VAR);
        if (var != null) {
            String value = null;
            ServiceResults sr = results.getServiceResults();
            if (sr != null) {
                value = sr.getStdout();
            }
            session.setVariableValue(var, value);
        }
    }
}

