/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.service.standard.Groovy;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class GroovyActionNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "groovy";
    private static final String ATTR_NAME = "name";
    private static final String MSG = "com.sas.dpro.contract.parser.GroovyActionNodeHandler";
    private static ResourceBundle msg;

    public GroovyActionNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    private static synchronized ResourceBundle getErrorBundle() {
        if (msg == null) {
            msg = ResourceBundle.getBundle(MSG);
        }
        return msg;
    }

    private String getScriptNameForFile(String file) {
        int slash = file.lastIndexOf(47);
        return (slash = Math.max(slash, file.lastIndexOf(92))) == -1 ? file : file.substring(slash + 1);
    }

    private BufferedReader getScriptObjectFromFile(ContainerContext cc, String file, Charset cs) throws NodeHandlerException {
        BufferedReader r = null;
        try {
            InputStream in = DProUtil.getFileContents(cc, file);
            in = DProUtil.possiblyReadBOM(in, cs);
            r = new BufferedReader(new InputStreamReader(in, cs));
        }
        catch (InvalidProviderNameException ipne) {
            ResourceBundle msg = GroovyActionNodeHandler.getErrorBundle();
            String key = "Error.ReadingScriptFile.fmt.txt";
            String desc = DProUtil.formatString(msg, key, new Object[]{this.getHandledNodeType(), file, ipne.getMessage()});
            throw new NodeHandlerException(desc, ipne);
        }
        catch (IOException ioe) {
            ResourceBundle msg = GroovyActionNodeHandler.getErrorBundle();
            String key = "Error.ReadingScriptFile.fmt.txt";
            String desc = DProUtil.formatString(msg, key, new Object[]{this.getHandledNodeType(), file, ioe.getMessage()});
            throw new NodeHandlerException(desc, ioe);
        }
        return r;
    }

    private void handleMultipleScriptsSpecified(File contract) throws InvalidContractException {
        ResourceBundle msg = GroovyActionNodeHandler.getErrorBundle();
        String key = "Error.MultipleScripts.fmt.txt";
        String desc = DProUtil.formatString(msg, key, this.getHandledNodeType());
        throw new InvalidContractException(desc, contract);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        boolean groovyEnabled = Groovy.isGroovyEnabled();
        if (!groovyEnabled) {
            ResourceBundle msg = GroovyActionNodeHandler.getErrorBundle();
            String key = "Error.GroovyNotEnabled.fmt.txt";
            String localP = ProviderFactory.getLocalProviderName();
            String desc = DProUtil.formatString(msg, key, this.getHandledNodeType(), localP);
            throw new NodeHandlerException(desc);
        }
        Object script = null;
        String scriptName = null;
        String saveOutputVar = null;
        String orig = node.getAttributeValue("outputVar");
        if (orig != null) {
            saveOutputVar = this.getVariableNameChecked(orig, false, session, runner, contract);
        }
        for (Element child : node.getChildren()) {
            String childName = child.getName();
            if ("script".equals(childName)) {
                if (script != null) {
                    this.handleMultipleScriptsSpecified(contract);
                }
                script = child.getText();
                script = session.replaceVariables((String)script);
                scriptName = child.getAttributeValue(ATTR_NAME);
                if (scriptName != null) {
                    scriptName = session.replaceVariables(scriptName);
                }
                if (scriptName != null) continue;
                scriptName = "inlineGroovyScript";
                continue;
            }
            if (!"scriptFile".equals(childName)) continue;
            if (script != null) {
                this.handleMultipleScriptsSpecified(contract);
            }
            ContainerContext cc = session.getDefaultContainer();
            orig = child.getAttributeValue("container");
            if (orig != null) {
                cc = this.getContainerContextChecked(orig, session, runner, contract);
            }
            String scriptFile = child.getText();
            scriptFile = session.replaceVariables(scriptFile);
            String csName = child.getAttributeValue("characterSet");
            Charset cs = this.getCharsetChecked(csName, session, runner, contract);
            script = this.getScriptObjectFromFile(cc, scriptFile, cs);
            scriptName = this.getScriptNameForFile(scriptFile);
        }
        if (script == null) {
            ResourceBundle msg = GroovyActionNodeHandler.getErrorBundle();
            String key = "Error.NoScript.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getHandledNodeType());
            throw new InvalidContractException(desc, contract);
        }
        Object output = null;
        try {
            Binding binding = new Binding();
            binding.setVariable("runner", (Object)runner);
            binding.setVariable("session", (Object)session);
            binding.setVariable("contract", (Object)contract);
            GroovyShell shell = new GroovyShell(binding);
            try {
                output = script instanceof String ? shell.evaluate((String)script, scriptName) : shell.evaluate((Reader)((BufferedReader)script), scriptName);
            }
            catch (Exception e) {
                ResourceBundle msg = GroovyActionNodeHandler.getErrorBundle();
                String key = "Error.EvaluatingGroovyCode.fmt.txt";
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                text = DProUtil.formatString(msg, key, this.getHandledNodeType(), text);
                throw new NodeHandlerException(text, e);
            }
        }
        finally {
            if (script instanceof BufferedReader) {
                try {
                    ((BufferedReader)script).close();
                }
                catch (IOException ioe) {
                    ResourceBundle msg = GroovyActionNodeHandler.getErrorBundle();
                    String key = "Error.ClosingInputStream.fmt.txt";
                    String desc = DProUtil.formatString(msg, key, this.getHandledNodeType());
                    throw new NodeHandlerException(desc, ioe);
                }
            }
        }
        if (saveOutputVar != null) {
            String value = output == null ? null : output.toString();
            session.setVariableValue(saveOutputVar, value);
        }
        return new DefaultNodeHandlerResults();
    }
}

