/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class GetTimeSpanStringNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "getTimeSpanString";
    private static final String PARAM_FORMAT = "format";
    private static final String ATTR_END_TIME = "endTime";
    private static final String ATTR_START_TIME = "startTime";
    private static final String ATTR_TIME_SPAN = "timeSpan";
    private static final String ATTR_VAR = "variable";
    private static final int ONE_DAY = 24;
    private static final int ONE_HOUR = 60;
    private static final int ONE_MINUTE = 60;
    private static final int ONE_SECOND = 1000;
    private static final double[] LIMITS = new double[]{0.0, 1.0, 2.0};
    private static final String[] DAYS_PART;
    private static final String[] HOURS_PART;
    private static final String[] MINUTES_PART;
    private static final String[] SECONDS_PART;
    private static final String MSG = "com.sas.dpro.contract.parser.GetTimeSpanStringNodeHandler";

    public GetTimeSpanStringNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    public static String formatElapsedTime(long millis) {
        MessageFormat fmt = new MessageFormat("{0}{1}{2}{3}");
        ChoiceFormat DAYS_FORMAT = new ChoiceFormat(LIMITS, DAYS_PART);
        ChoiceFormat HOURS_FORMAT = new ChoiceFormat(LIMITS, HOURS_PART);
        ChoiceFormat MINUTES_FORMAT = new ChoiceFormat(LIMITS, MINUTES_PART);
        ChoiceFormat SECONDS_FORMAT = new ChoiceFormat(LIMITS, SECONDS_PART);
        fmt.setFormat(0, DAYS_FORMAT);
        fmt.setFormat(1, HOURS_FORMAT);
        fmt.setFormat(2, MINUTES_FORMAT);
        fmt.setFormat(3, SECONDS_FORMAT);
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        Object[] args = new Object[]{days, hours % 24L, minutes % 60L, seconds % 60L};
        return fmt.format(args);
    }

    private long getLong(String attr, String orig, String evaluated, ContractRunner runner) throws InvalidContractException {
        try {
            long l = Long.parseLong(evaluated);
            if (l < 0L) {
                throw new NumberFormatException();
            }
            return l;
        }
        catch (NumberFormatException nfe) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.InvalidAttribute.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), attr, evaluated, orig);
            throw new InvalidContractException(desc);
        }
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        DefaultNodeHandlerResults res = new DefaultNodeHandlerResults();
        String formatStr = node.getChildText(PARAM_FORMAT);
        if (formatStr != null) {
            formatStr = session.replaceVariables(formatStr);
        }
        long timeSpan = 0L;
        String timeSpanStr = node.getAttributeValue(ATTR_TIME_SPAN);
        if (timeSpanStr == null) {
            String startTimeStr = node.getAttributeValue(ATTR_START_TIME);
            if (startTimeStr == null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.AttributeMissing2.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), ATTR_TIME_SPAN, ATTR_START_TIME);
                throw new InvalidContractException(desc);
            }
            String evaluated = session.replaceVariables(startTimeStr);
            long startTime = this.getLong(ATTR_START_TIME, startTimeStr, evaluated, runner);
            String endTimeStr = node.getAttributeValue(ATTR_END_TIME);
            long endTime = 0L;
            if (endTimeStr == null) {
                endTime = System.currentTimeMillis();
            } else {
                evaluated = session.replaceVariables(endTimeStr);
                endTime = this.getLong(ATTR_END_TIME, endTimeStr, evaluated, runner);
            }
            timeSpan = endTime - startTime;
        } else {
            if (node.getAttributeValue(ATTR_START_TIME) != null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.CannotSpecifyBoth.fmt.txt");
                desc = MessageFormat.format(desc, ATTR_TIME_SPAN, ATTR_START_TIME, this.getHandledNodeType());
                throw new InvalidContractException(desc);
            }
            if (node.getAttributeValue(ATTR_END_TIME) != null) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.CannotSpecifyBoth.fmt.txt");
                desc = MessageFormat.format(desc, ATTR_TIME_SPAN, ATTR_END_TIME, this.getHandledNodeType());
                throw new InvalidContractException(desc);
            }
            String evaluated = session.replaceVariables(timeSpanStr);
            timeSpan = this.getLong(ATTR_TIME_SPAN, timeSpanStr, evaluated, runner);
        }
        String orig = node.getAttributeValue(ATTR_VAR);
        String var = this.getVariableNameChecked(orig, false, session, runner, contract);
        session.setVariableValue(var, GetTimeSpanStringNodeHandler.formatElapsedTime(timeSpan));
        return res;
    }

    static {
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        DAYS_PART = new String[]{"", msg.getString("OneDay.fmt.txt"), msg.getString("MultipleDays.fmt.txt")};
        HOURS_PART = new String[]{"", msg.getString("OneHour.fmt.txt"), msg.getString("MultipleHours.fmt.txt")};
        MINUTES_PART = new String[]{"", msg.getString("OneMinute.fmt.txt"), msg.getString("MultipleMinutes.fmt.txt")};
        SECONDS_PART = new String[]{msg.getString("ZeroSeconds.fmt.txt"), msg.getString("OneSecond.fmt.txt"), msg.getString("MultipleSeconds.fmt.txt")};
    }
}

