/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.service.ServiceResults;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import org.jdom2.Element;

public class GetServiceResultsInfoNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "getServiceResultsInfo";
    private static final String PARAM_PROPERTY = "property";
    private static final String ATTR_FAIL_IF_RESULTS_DNE = "failIfNoSuchResults";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_RESULTS = "results";
    private static final String ATTR_VARIABLE = "variable";
    public static final String PROPERTY_COMMAND = "command";
    public static final String PROPERTY_CONTAINER = "containerID";
    public static final String PROPERTY_DEFAULT_TIMEOUT = "defaultTimeout";
    public static final String PROPERTY_KEYWORDS = "keywords";
    public static final String PROPERTY_OUTPUT_STREAMS_CAPTURED = "outputStreamsCaptured";
    public static final String PROPERTY_OUTPUT_STREAMS_CAPTURED_STR = "outputStreamsCapturedStr";
    public static final String PROPERTY_PROVIDER = "server";
    public static final String PROPERTY_RC = "rc";
    public static final String PROPERTY_SERVICE_DESC = "serviceDesc";
    public static final String PROPERTY_SERVICE_NAME = "service";
    public static final String PROPERTY_STDERR = "stderr";
    public static final String PROPERTY_STDERR_REDIRECTED = "stderrRedirected";
    public static final String PROPERTY_STDOUT = "stdout";
    public static final String PROPERTY_TIME = "time";
    public static final String PROPERTY_TIME_SECONDS = "timeInSeconds";
    public static final String UNKNOWN_PROPERTY = "UnknownProperty";
    public static final String NO_SUCH_RESULTS = "NoSuchResults";

    public GetServiceResultsInfoNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String orig = node.getAttributeValue(ATTR_FAIL_IF_RESULTS_DNE);
        boolean failIfResultsDNE = this.getBoolean(orig, session, true);
        orig = node.getAttributeValue(ATTR_RESULTS);
        ServiceResults sr = null;
        if (failIfResultsDNE) {
            sr = this.getServiceResultsChecked(orig, session, runner, contract);
        } else {
            String id = session.replaceVariables(orig);
            sr = session.getServiceResultsByID(id);
        }
        List children = node.getChildren();
        for (Element child : children) {
            String name = child.getName();
            if (!PARAM_PROPERTY.equals(name)) continue;
            String propName = child.getAttributeValue(ATTR_NAME);
            propName = session.replaceVariables(propName);
            orig = child.getAttributeValue(ATTR_VARIABLE);
            String var = this.getVariableNameChecked(orig, false, session, runner, contract);
            String propValue = UNKNOWN_PROPERTY;
            if (sr == null) {
                propValue = NO_SUCH_RESULTS;
            } else if (PROPERTY_COMMAND.equals(propName)) {
                propValue = sr.getCommandExecuted();
            } else if (PROPERTY_CONTAINER.equals(propName)) {
                propValue = sr.getContainerContextID();
            } else if (PROPERTY_DEFAULT_TIMEOUT.equals(propName)) {
                propValue = Long.toString(sr.getServiceInfo().getDefaultTimeout());
            } else if (PROPERTY_KEYWORDS.equals(propName)) {
                propValue = sr.getServiceInfo().getKeywords();
            } else if (PROPERTY_OUTPUT_STREAMS_CAPTURED.equals(propName)) {
                propValue = Integer.toString(sr.getOutputStreamsCaptured());
            } else if (PROPERTY_OUTPUT_STREAMS_CAPTURED_STR.equals(propName)) {
                switch (sr.getOutputStreamsCaptured()) {
                    case 0: {
                        propValue = "false";
                        break;
                    }
                    case 2: {
                        propValue = "combine";
                        break;
                    }
                    case 1: {
                        propValue = "true";
                        break;
                    }
                    default: {
                        propValue = "Error_UnknownOutputStreamsCapturedValue";
                        break;
                    }
                }
            } else if (PROPERTY_PROVIDER.equals(propName)) {
                propValue = sr.getServiceInfo().getHost();
                if (propValue == null) {
                    propValue = "server-local";
                }
            } else if (PROPERTY_RC.equals(propName)) {
                propValue = Integer.toString(sr.getReturnCode());
            } else if (PROPERTY_SERVICE_DESC.equals(propName)) {
                propValue = sr.getServiceInfo().getDescription();
            } else if (PROPERTY_SERVICE_NAME.equals(propName)) {
                propValue = sr.getServiceName();
            } else if (PROPERTY_STDERR.equals(propName)) {
                propValue = sr.getStderr();
            } else if (PROPERTY_STDERR_REDIRECTED.equals(propName)) {
                propValue = Boolean.toString(sr.getStderrRedirected());
            } else if (PROPERTY_STDOUT.equals(propName)) {
                propValue = sr.getStdout();
            } else if (PROPERTY_TIME.equals(propName)) {
                propValue = Long.toString(sr.getTime());
            } else if (PROPERTY_TIME_SECONDS.equals(propName)) {
                float secs = (float)sr.getTime() / 1.0E9f;
                propValue = Float.toString(secs);
            }
            session.setVariableValue(var, propValue);
        }
        return new DefaultNodeHandlerResults();
    }
}

