/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.ContractInfo;
import com.sas.dpro.contract.parser.ContractNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.provider.ProviderInfo;
import com.sas.dpro.service.ServiceInfo;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class GetServerInfoNodeHandler
implements ContractNodeHandler {
    public static final String HANDLED_NODE_TYPE = "getServerInfo";
    public static final String UNAVAILABLE = "ServerUnavailable";
    public static final String UNKNOWN_PROPERTY = "UnknownProperty";
    public static final String PROPERTY_AVAILABLE = "available";
    public static final String PROPERTY_BUILD_VERSION = "buildVersion";
    public static final String PROPERTY_DPRO_VERSION = "dproVersion";
    public static final String PROPERTY_EXTERNAL_SERVICES = "externalServices";
    public static final String PROPERTY_FILE_ENCODING = "fileEncoding";
    public static final String PROPERTY_FILE_SEPARATOR = "fileSeparator";
    public static final String PROPERTY_HOST_IP = "hostIPAddress";
    public static final String PROPERTY_HOST_NAME = "hostName";
    public static final String PROPERTY_INTERNAL_SERVICES = "internalServices";
    public static final String PROPERTY_OS_ARCH = "osArchitecture";
    public static final String PROPERTY_OS_NAME = "osName";
    public static final String PROPERTY_OS_VERSION = "osVersion";
    public static final String PROPERTY_PATH_SEPARATOR = "pathSeparator";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_PROPERTY_PREFIX = "property:";
    public static final String PROPERTY_SERVICES = "services";
    public static final String PROPERTY_STORED_CONTRACTS = "storedContracts";
    public static final String PROPERTY_SUPPORTS_CHECKSUM_PREFIX = "supportsChecksum:";
    public static final String PROPERTY_SUPPORTS_ENCODING_PREFIX = "supportsEncoding:";
    public static final String PROPERTY_UPTIME = "upTime";
    private static final String PARAM_PROPERTY = "property";
    private static final String ATTR_FAIL_IF_UNAVAILABLE = "failIfServerUnavailable";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SERVER = "server";
    private static final String ATTR_VARIABLE = "variable";

    private static final boolean checkForProperty(List children, String prop, ContractSession session) {
        if (prop == null) {
            return false;
        }
        for (Element elem : children) {
            String elemName = elem.getName();
            if (!PARAM_PROPERTY.equals(elemName)) continue;
            String propName = elem.getAttributeValue(ATTR_NAME);
            if (!prop.equals(propName = session.replaceVariables(propName))) continue;
            return true;
        }
        return false;
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        List children = node.getChildren();
        String origServer = node.getAttributeValue(ATTR_SERVER);
        String server = session.replaceVariables(origServer);
        boolean failIfUnavailable = false;
        String orig = node.getAttributeValue(ATTR_FAIL_IF_UNAVAILABLE);
        if (orig != null) {
            String failStr = session.replaceVariables(orig);
            failIfUnavailable = runner.ensureBoolean(failStr, HANDLED_NODE_TYPE, ATTR_FAIL_IF_UNAVAILABLE, orig);
        }
        boolean getServiceInfos = GetServerInfoNodeHandler.checkForProperty(children, PROPERTY_SERVICES, session);
        getServiceInfos |= GetServerInfoNodeHandler.checkForProperty(children, PROPERTY_EXTERNAL_SERVICES, session);
        boolean getContractInfos = GetServerInfoNodeHandler.checkForProperty(children, PROPERTY_STORED_CONTRACTS, session);
        ProviderInfo providerInfo = ProviderFactory.createProviderInfo(server, getServiceInfos |= GetServerInfoNodeHandler.checkForProperty(children, PROPERTY_INTERNAL_SERVICES, session), getContractInfos);
        boolean available = providerInfo.isAvailable();
        Provider p = null;
        if (!available && failIfUnavailable) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.ServerNotAvailable.fmt.txt");
            desc = MessageFormat.format(desc, HANDLED_NODE_TYPE, server);
            throw new InvalidContractException(desc, contract);
        }
        for (Element child : children) {
            int j;
            int j2;
            int pos;
            StringBuilder sb;
            int count;
            ServiceInfo[] si;
            String name = child.getName();
            if (!PARAM_PROPERTY.equals(name)) continue;
            String propName = child.getAttributeValue(ATTR_NAME);
            propName = session.replaceVariables(propName);
            String origVar = child.getAttributeValue(ATTR_VARIABLE);
            String var = session.replaceVariables(origVar);
            if (!DProUtil.isValidVariableName(var)) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.InvalidVarName.fmt.txt");
                desc = MessageFormat.format(desc, HANDLED_NODE_TYPE, origVar, var);
                throw new InvalidContractException(desc, contract);
            }
            String propValue = UNKNOWN_PROPERTY;
            if (PROPERTY_AVAILABLE.equals(propName)) {
                propValue = "" + available;
            } else if (PROPERTY_BUILD_VERSION.equals(propName)) {
                propValue = available ? providerInfo.getProviderBuildVersion() : UNAVAILABLE;
            } else if (PROPERTY_DPRO_VERSION.equals(propName)) {
                propValue = available ? providerInfo.getProviderDPROVersion() : UNAVAILABLE;
            } else if (PROPERTY_EXTERNAL_SERVICES.equals(propName)) {
                if (available) {
                    si = providerInfo.getServiceInfos();
                    count = si == null ? 0 : si.length;
                    sb = new StringBuilder();
                    pos = 0;
                    for (j2 = 0; j2 < count; ++j2) {
                        if (si[j2].isInternalService()) continue;
                        if (pos > 0) {
                            sb.append(';');
                        }
                        sb.append(si[j2].getName());
                        ++pos;
                    }
                    propValue = sb.toString();
                } else {
                    propValue = UNAVAILABLE;
                }
            } else if (PROPERTY_FILE_ENCODING.equals(propName)) {
                propValue = available ? providerInfo.getHostInfo().getFileEncoding() : UNAVAILABLE;
            } else if (PROPERTY_FILE_SEPARATOR.equals(propName)) {
                propValue = available ? providerInfo.getHostInfo().getFileSeparator() : UNAVAILABLE;
            } else if (PROPERTY_HOST_IP.equals(propName)) {
                propValue = available ? providerInfo.getHostInfo().getHostIPAddress() : UNAVAILABLE;
            } else if (PROPERTY_HOST_NAME.equals(propName)) {
                propValue = available ? providerInfo.getHostInfo().getHostName() : UNAVAILABLE;
            } else if (PROPERTY_INTERNAL_SERVICES.equals(propName)) {
                if (available) {
                    si = providerInfo.getServiceInfos();
                    count = si == null ? 0 : si.length;
                    sb = new StringBuilder();
                    pos = 0;
                    for (j2 = 0; j2 < count; ++j2) {
                        if (!si[j2].isInternalService()) continue;
                        if (pos > 0) {
                            sb.append(';');
                        }
                        sb.append(si[j2].getName());
                        ++pos;
                    }
                    propValue = sb.toString();
                } else {
                    propValue = UNAVAILABLE;
                }
            } else if (PROPERTY_OS_ARCH.equals(propName)) {
                propValue = available ? providerInfo.getHostInfo().getOSArchitecture() : UNAVAILABLE;
            } else if (PROPERTY_OS_NAME.equals(propName)) {
                propValue = available ? providerInfo.getHostInfo().getOSName() : UNAVAILABLE;
            } else if (PROPERTY_OS_VERSION.equals(propName)) {
                propValue = available ? providerInfo.getHostInfo().getOSVersion() : UNAVAILABLE;
            } else if (PROPERTY_PATH_SEPARATOR.equals(propName)) {
                propValue = available ? providerInfo.getHostInfo().getPathSeparator() : UNAVAILABLE;
            } else if (PROPERTY_PORT.equals(propName)) {
                propValue = available ? "" + providerInfo.getPort() : UNAVAILABLE;
            } else if (propName.startsWith(PROPERTY_PROPERTY_PREFIX)) {
                if (available) {
                    propName = propName.substring(PROPERTY_PROPERTY_PREFIX.length());
                    if (p == null) {
                        p = ProviderFactory.getProvider(server);
                    }
                    propValue = p.getProperty(propName);
                } else {
                    propValue = UNAVAILABLE;
                }
            } else if (PROPERTY_SERVICES.equals(propName)) {
                if (available) {
                    si = providerInfo.getServiceInfos();
                    count = si == null ? 0 : si.length;
                    sb = new StringBuilder();
                    for (j = 0; j < count; ++j) {
                        if (j > 0) {
                            sb.append(';');
                        }
                        sb.append(si[j].getName());
                    }
                    propValue = sb.toString();
                } else {
                    propValue = UNAVAILABLE;
                }
            } else if (PROPERTY_STORED_CONTRACTS.equals(propName)) {
                if (available) {
                    ContractInfo[] ci = providerInfo.getStoredContractInfos();
                    count = ci == null ? 0 : ci.length;
                    sb = new StringBuilder();
                    for (j = 0; j < count; ++j) {
                        String temp = ci[j].getDisplayName();
                        if (temp == null) {
                            temp = ci[j].getFileName();
                        }
                        if (j > 0) {
                            sb.append(';');
                        }
                        sb.append(temp);
                    }
                    propValue = sb.toString();
                } else {
                    propValue = UNAVAILABLE;
                }
            } else if (propName.startsWith(PROPERTY_SUPPORTS_CHECKSUM_PREFIX)) {
                if (available) {
                    propName = propName.substring(PROPERTY_SUPPORTS_CHECKSUM_PREFIX.length());
                    if (p == null) {
                        p = ProviderFactory.getProvider(server);
                    }
                    propValue = "" + p.getSupportsChecksumType(propName);
                } else {
                    propValue = UNAVAILABLE;
                }
            } else if (propName.startsWith(PROPERTY_SUPPORTS_ENCODING_PREFIX)) {
                if (available) {
                    propName = propName.substring(PROPERTY_SUPPORTS_ENCODING_PREFIX.length());
                    if (p == null) {
                        p = ProviderFactory.getProvider(server);
                    }
                    propValue = "" + p.getSupportsEncoding(propName);
                } else {
                    propValue = UNAVAILABLE;
                }
            } else if (PROPERTY_UPTIME.equals(propName)) {
                propValue = available ? "" + providerInfo.getUpTime() : UNAVAILABLE;
            }
            session.setVariableValue(var, propValue);
        }
        return new DefaultNodeHandlerResults();
    }
}

