/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.ProviderNotAvailableException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class GetFileInfoNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "getFileInfo";
    public static final String FILE_DOES_NOT_EXIST = "FileDoesNotExist";
    public static final String UNAVAILABLE = "ServerUnavailable";
    public static final String UNKNOWN_PROPERTY = "UnknownProperty";
    public static final String PROPERTY_ADLER32 = "ADLER-32";
    public static final String PROPERTY_CAN_READ = "canRead";
    public static final String PROPERTY_CAN_WRITE = "canWrite";
    public static final String PROPERTY_CHILD_COUNT = "childCount";
    public static final String PROPERTY_CRC32 = "CRC-32";
    public static final String PROPERTY_EXISTS = "exists";
    public static final String PROPERTY_FULL_PATH = "fullPath";
    public static final String PROPERTY_IS_DIRECTORY = "isDirectory";
    public static final String PROPERTY_IS_FILE = "isFile";
    public static final String PROPERTY_IS_HIDDEN = "isHidden";
    public static final String PROPERTY_LAST_MODIFIED = "lastModified";
    public static final String PROPERTY_MD5 = "MD5";
    public static final String PROPERTY_SHA1 = "SHA-1";
    public static final String PROPERTY_SIZE = "size";
    private static final String PARAM_PROPERTY = "property";
    private static final String ATTR_FAIL_IF_UNAVAILABLE = "failIfServerUnavailable";
    private static final String ATTR_FILE_NAME = "file";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VARIABLE = "variable";

    public GetFileInfoNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        Provider p;
        String fileName;
        ContainerContext cc;
        block7: {
            String orig = node.getAttributeValue("container");
            cc = this.getContainerContextChecked(orig, session, runner, contract);
            orig = node.getAttributeValue(ATTR_FILE_NAME);
            fileName = session.replaceVariables(orig);
            boolean failIfServerUnavailable = false;
            orig = node.getAttributeValue(ATTR_FAIL_IF_UNAVAILABLE);
            if (orig != null) {
                String failStr = session.replaceVariables(orig);
                failIfServerUnavailable = runner.ensureBoolean(failStr, this.getHandledNodeType(), ATTR_FAIL_IF_UNAVAILABLE, orig);
            }
            String server = cc.getProviderName();
            p = null;
            try {
                p = ProviderFactory.getProvider(server);
            }
            catch (ProviderNotAvailableException pnae) {
                if (!failIfServerUnavailable) break block7;
                ResourceBundle msg = runner.getErrorBundle();
                String key = "Error.ServerNotAvailable.fmt.txt";
                String desc = DProUtil.formatString(msg, key, this.getHandledNodeType(), server);
                throw new InvalidContractException(desc, contract);
            }
        }
        ArrayList<String> propertyList = new ArrayList<String>(1);
        ArrayList<String> varList = new ArrayList<String>(1);
        List children = node.getChildren();
        for (Element child : children) {
            String name = child.getName();
            if (!PARAM_PROPERTY.equals(name)) continue;
            String propName = child.getAttributeValue(ATTR_NAME);
            propName = session.replaceVariables(propName);
            String origVar = child.getAttributeValue(ATTR_VARIABLE);
            String var = session.replaceVariables(origVar);
            if (!DProUtil.isValidVariableName(var)) {
                ResourceBundle msg = runner.getErrorBundle();
                String key = "Error.InvalidVarName.fmt.txt";
                String desc = DProUtil.formatString(msg, key, this.getHandledNodeType(), origVar, var);
                throw new InvalidContractException(desc, contract);
            }
            propertyList.add(propName);
            varList.add(var);
        }
        if (propertyList.size() > 0) {
            String[] properties = new String[propertyList.size()];
            properties = propertyList.toArray(properties);
            String[] values = p.getFileInfo(cc, fileName, properties);
            for (int i = 0; i < varList.size(); ++i) {
                String var = (String)varList.get(i);
                String value = values[i];
                session.setVariableValue(var, value);
            }
        }
        return new DefaultNodeHandlerResults();
    }
}

