/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractContractNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class GetContractSessionInfoNodeHandler
extends AbstractContractNodeHandler {
    public static final String HANDLED_NODE_TYPE = "getContractSessionInfo";
    public static final String UNKNOWN_PROPERTY = "UnknownProperty";
    public static final String PROPERTY_CONTRACT_NAME = "contractName";
    public static final String PROPERTY_DIR_LIST_DEFINED_PREFIX = "dirListDefined:";
    public static final String PROPERTY_DIR_SET_DEFINED_PREFIX = "dirSetDefined:";
    public static final String PROPERTY_FILE_LIST_DEFINED_PREFIX = "fileListDefined:";
    public static final String PROPERTY_FILE_SET_DEFINED_PREFIX = "fileSetDefined:";
    public static final String PROPERTY_FILTER_SET_DEFINED_PREFIX = "filterSetDefined:";
    public static final String PROPERTY_LAST_RC = "lastRC";
    public static final String PROPERTY_MACRO_DEFINED_PREFIX = "macroDefined:";
    public static final String PROPERTY_MESSAGE_GRANULARITY = "messageGranularity";
    public static final String PROPERTY_ORIGINAL_SESSION_ID = "originalSessionID";
    public static final String PROPERTY_PATTERN_SET_DEFINED_PREFIX = "patternSetDefined:";
    public static final String PROPERTY_SESSION_ID = "sessionID";
    public static final String PROPERTY_STARTED_REMOTELY = "startedRemotely";
    private static final String PARAM_PROPERTY = "property";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VARIABLE = "variable";

    public GetContractSessionInfoNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        List children = node.getChildren();
        for (Element child : children) {
            String fsID;
            String name = child.getName();
            if (!PARAM_PROPERTY.equals(name)) continue;
            String propName = child.getAttributeValue(ATTR_NAME);
            propName = session.replaceVariables(propName);
            String origVar = child.getAttributeValue(ATTR_VARIABLE);
            String var = session.replaceVariables(origVar);
            if (!DProUtil.isValidVariableName(var)) {
                ResourceBundle msg = runner.getErrorBundle();
                String desc = msg.getString("Error.InvalidVarName.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType(), origVar, var);
                throw new InvalidContractException(desc, contract);
            }
            String propValue = UNKNOWN_PROPERTY;
            if (PROPERTY_CONTRACT_NAME.equals(propName)) {
                propValue = session.getContractName();
            } else if (propName.startsWith(PROPERTY_DIR_LIST_DEFINED_PREFIX)) {
                String dlID = propName.substring(PROPERTY_DIR_LIST_DEFINED_PREFIX.length());
                propValue = session.getDirList(dlID) != null ? "true" : "false";
            } else if (propName.startsWith(PROPERTY_DIR_SET_DEFINED_PREFIX)) {
                String dsID = propName.substring(PROPERTY_DIR_SET_DEFINED_PREFIX.length());
                propValue = session.getDirSet(dsID) != null ? "true" : "false";
            } else if (propName.startsWith(PROPERTY_FILE_LIST_DEFINED_PREFIX)) {
                String flID = propName.substring(PROPERTY_FILE_LIST_DEFINED_PREFIX.length());
                propValue = session.getFileList(flID) != null ? "true" : "false";
            } else if (propName.startsWith(PROPERTY_FILTER_SET_DEFINED_PREFIX)) {
                fsID = propName.substring(PROPERTY_FILTER_SET_DEFINED_PREFIX.length());
                propValue = session.getFilterSet(fsID) != null ? "true" : "false";
            } else if (propName.startsWith(PROPERTY_FILE_SET_DEFINED_PREFIX)) {
                fsID = propName.substring(PROPERTY_FILE_SET_DEFINED_PREFIX.length());
                propValue = session.getFileSet(fsID) != null ? "true" : "false";
            } else if (PROPERTY_LAST_RC.equals(propName)) {
                propValue = "" + session.getLastRC();
            } else if (propName.startsWith(PROPERTY_MACRO_DEFINED_PREFIX)) {
                String macro = propName.substring(PROPERTY_MACRO_DEFINED_PREFIX.length());
                propValue = session.getMacro(macro) != null ? "true" : "false";
            } else if (PROPERTY_MESSAGE_GRANULARITY.equals(propName)) {
                propValue = "" + session.getMessageGranularity();
            } else if (PROPERTY_ORIGINAL_SESSION_ID.equals(propName)) {
                propValue = "" + session.getHonorContractContext().getOriginalContractSessionID();
            } else if (PROPERTY_SESSION_ID.equals(propName)) {
                propValue = "" + session.getSessionID();
            } else if (propName.startsWith(PROPERTY_PATTERN_SET_DEFINED_PREFIX)) {
                String psID = propName.substring(PROPERTY_PATTERN_SET_DEFINED_PREFIX.length());
                propValue = session.getPatternSet(psID) != null ? "true" : "false";
            } else if (PROPERTY_STARTED_REMOTELY.equals(propName)) {
                propValue = "" + session.getStartedRemotely();
            }
            session.setVariableValue(var, propValue);
        }
        return new DefaultNodeHandlerResults();
    }
}

