/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import org.jdom2.Element;

public class GetContainerInfoNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "getContainerInfo";
    public static final String NOT_AVAILABLE = "NotAvailable";
    public static final String UNKNOWN_PROPERTY = "UnknownProperty";
    public static final String PROPERTY_AVAILABLE = "available";
    public static final String PROPERTY_CLIENT_DPRO_VERSION = "clientDPROVersion";
    public static final String PROPERTY_CONTRACT_ID = "contractID";
    public static final String PROPERTY_CONTRACT_SESSION_ID = "contractSessionID";
    public static final String PROPERTY_LIFESPAN = "lifeSpan";
    public static final String PROPERTY_LIFESPAN_STR = "lifeSpanString";
    public static final String PROPERTY_SERVER = "server";
    public static final String PROPERTY_SERVER_DPRO_VERSION = "serverDPROVersion";
    public static final String PROPERTY_TEMPORARY = "temporary";
    public static final String PROPERTY_TIME_CREATED = "creationTime";
    public static final String PROPERTY_WAS_NEWLY_CREATED = "wasNewlyCreated";
    public static final String PROPERTY_WORKING_DIR = "workingDir";
    public static final String LIFESPAN_PERMANENT_STR = "permanent";
    public static final String LIFESPAN_TEMPORARY_CONTRACT_STR = "temporary_contract";
    public static final String LIFESPAN_TEMPORARY_CONTROLLER_STR = "temporary_controller";
    public static final String LIFESPAN_UNKNOWN = "Unknown";
    static final String PARAM_PROPERTY = "property";
    private static final String ATTR_FAIL_IF_NOT_AVAILABLE = "failIfNotAvailable";
    static final String ATTR_NAME = "name";
    static final String ATTR_VARIABLE = "variable";

    public GetContainerInfoNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    public static String getPropValue(String propName, ContainerContext cc) throws InvalidContractException {
        String propValue = UNKNOWN_PROPERTY;
        if (PROPERTY_AVAILABLE.equals(propName)) {
            propValue = Boolean.toString(cc != null);
        } else if (cc == null) {
            propValue = NOT_AVAILABLE;
        } else if (PROPERTY_CLIENT_DPRO_VERSION.equals(propName)) {
            propValue = cc.getClientDPROVersion();
        } else if (PROPERTY_CONTRACT_ID.equals(propName)) {
            propValue = cc.getContractID();
        } else if (PROPERTY_CONTRACT_SESSION_ID.equals(propName)) {
            propValue = Long.toString(cc.getContractSessionID());
        } else if (PROPERTY_LIFESPAN.equals(propName)) {
            propValue = Integer.toString(cc.getLifespan());
        } else if (PROPERTY_LIFESPAN_STR.equals(propName)) {
            switch (cc.getLifespan()) {
                case 0: {
                    propValue = LIFESPAN_PERMANENT_STR;
                    break;
                }
                case 1: {
                    propValue = LIFESPAN_TEMPORARY_CONTRACT_STR;
                    break;
                }
                case 2: {
                    propValue = LIFESPAN_TEMPORARY_CONTROLLER_STR;
                    break;
                }
                default: {
                    propValue = LIFESPAN_UNKNOWN;
                    break;
                }
            }
        } else if (PROPERTY_SERVER.equals(propName)) {
            propValue = cc.getProviderName();
        } else if (PROPERTY_SERVER_DPRO_VERSION.equals(propName)) {
            propValue = cc.getProviderDPROVersion();
        } else if (PROPERTY_TEMPORARY.equals(propName)) {
            propValue = Boolean.toString(cc.isTemporary());
        } else if (PROPERTY_TIME_CREATED.equals(propName)) {
            propValue = Long.toString(cc.getTimeCreated());
        } else if (PROPERTY_WAS_NEWLY_CREATED.equals(propName)) {
            propValue = Boolean.toString(cc.getWasNewlyCreated());
        } else if (PROPERTY_WORKING_DIR.equals(propName)) {
            propValue = cc.getDirectory();
        }
        return propValue;
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        boolean failIfNotAvailable = true;
        String orig = node.getAttributeValue(ATTR_FAIL_IF_NOT_AVAILABLE);
        if (orig != null) {
            String value = session.replaceVariables(orig);
            failIfNotAvailable = runner.ensureBoolean(value, this.getHandledNodeType(), ATTR_FAIL_IF_NOT_AVAILABLE, orig);
        }
        orig = node.getAttributeValue("container");
        ContainerContext cc = null;
        if (failIfNotAvailable) {
            cc = this.getContainerContextChecked(orig, session, runner, contract);
        } else {
            String id = session.replaceVariables(orig);
            cc = session.getContainerContext(id);
        }
        List children = node.getChildren();
        for (Element child : children) {
            String name = child.getName();
            if (!PARAM_PROPERTY.equals(name)) continue;
            String propName = child.getAttributeValue(ATTR_NAME);
            propName = session.replaceVariables(propName);
            orig = child.getAttributeValue(ATTR_VARIABLE);
            String var = this.getVariableNameChecked(orig, false, session, runner, contract);
            String propValue = GetContainerInfoNodeHandler.getPropValue(propName, cc);
            session.setVariableValue(var, propValue);
        }
        return new DefaultNodeHandlerResults();
    }
}

