/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

class FtpNodeHandler
extends DefaultInternalServiceNodeHandler {
    private static final String LOCAL_NAME = "localName";
    private static final String REMOTE_NAME = "remoteName";

    public FtpNodeHandler() {
        super("Ftp");
    }

    @Override
    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        String host = null;
        int port = 21;
        String userid = null;
        String password = null;
        String protocol = "ftp";
        ArrayList<String> commands = new ArrayList<String>();
        for (Element elem2 : childNodeList) {
            String name = elem2.getName();
            if ("host".equals(name)) {
                host = session.replaceVariables(elem2.getTextTrim());
                continue;
            }
            if ("port".equals(name)) {
                String temp = session.replaceVariables(elem2.getTextTrim());
                try {
                    port = Integer.parseInt(temp);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidContractException(contract, (Throwable)nfe);
                }
            }
            if ("userid".equals(name)) {
                userid = session.replaceVariables(elem2.getText());
                userid = this.possiblyEncrypt(runner, "userid", userid);
                continue;
            }
            if ("password".equals(name)) {
                password = session.replaceVariables(elem2.getText());
                password = this.possiblyEncrypt(runner, "password", password);
                continue;
            }
            if ("protocol".equals(name)) {
                protocol = session.replaceVariables(elem2.getText());
                continue;
            }
            if ("commands".equals(name)) {
                for (Element elem2 : elem2.getChildren()) {
                    String command;
                    String file;
                    String dir;
                    name = elem2.getName();
                    if ("cd".equals(name)) {
                        dir = elem2.getText();
                        dir = session.replaceVariables(dir);
                        commands.add("cd \"" + dir + "\"");
                        continue;
                    }
                    if ("pwd".equals(name)) {
                        commands.add("pwd");
                        continue;
                    }
                    if ("ls".equals(name)) {
                        commands.add("ls");
                        continue;
                    }
                    if ("binary".equals(name)) {
                        commands.add("binary");
                        continue;
                    }
                    if ("ascii".equals(name)) {
                        commands.add("ascii");
                        continue;
                    }
                    if ("ebcdic".equals(name)) {
                        commands.add("ebcdic");
                        continue;
                    }
                    if ("get".equals(name)) {
                        file = elem2.getText();
                        file = session.replaceVariables(file);
                        command = "get \"" + file + "\"";
                        String localName = elem2.getAttributeValue(LOCAL_NAME);
                        if (localName != null) {
                            command = command + " \"" + localName + "\"";
                        }
                        commands.add(command);
                        continue;
                    }
                    if ("put".equals(name)) {
                        file = elem2.getText();
                        file = session.replaceVariables(file);
                        command = "put \"" + file + "\"";
                        String remoteName = elem2.getAttributeValue(REMOTE_NAME);
                        if (remoteName != null) {
                            command = command + " \"" + remoteName + "\"";
                        }
                        commands.add(command);
                        continue;
                    }
                    if ("mkdir".equals(name)) {
                        dir = elem2.getText();
                        dir = session.replaceVariables(dir);
                        commands.add("mkdir \"" + dir + "\"");
                        continue;
                    }
                    if (!"dele".equals(name)) continue;
                    file = elem2.getText();
                    file = session.replaceVariables(file);
                    commands.add("dele \"" + file + "\"");
                }
                continue;
            }
            throw new InvalidContractException("FTP: Unknown element: " + name);
        }
        params.put("host", host);
        params.put("port", new Integer(port));
        params.put("userid", userid);
        params.put("password", password);
        params.put("protocol", protocol);
        String[] cmdArray = new String[commands.size()];
        cmdArray = commands.toArray(cmdArray);
        params.put("commands", cmdArray);
    }
}

