/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class FormatNodeHandler
extends DefaultInternalServiceNodeHandler {
    public static final String PARAM_TYPE_LOCATION = "location";
    public static final String PARAM_TYPE_VALUE = "value";
    private static final String PARAM_FILE = "file";
    public static final String PARAM_FILES_TO_FORMAT = "filesToFormat";
    public static final String PARAM_PARAM = "param";
    public static final String PARAM_PARAMS = "params";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";

    public FormatNodeHandler() {
        super("Format");
    }

    @Override
    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        boolean toFormatSpecified = false;
        for (Element child : childNodeList) {
            String name = child.getName();
            if (PARAM_PARAMS.equals(name)) {
                this.handleParamsNode(child, runner, session, contract, params);
                continue;
            }
            if (PARAM_FILES_TO_FORMAT.equals(name)) {
                this.handleFilesToFormatNode(child, runner, session, contract, params);
                toFormatSpecified = true;
                continue;
            }
            if (!"formatType".equals(name)) continue;
            String type = child.getAttributeValue(ATTR_TYPE);
            type = session.replaceVariables(type);
            params.put("formatType", type);
        }
        if (!toFormatSpecified) {
            ContainerContext cont = this.getContainer(session, this.getHandledNodeType(), params);
            params.put("_ContainerToFormat", cont);
        }
    }

    protected void handleFilesToFormatNode(Element node, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        String orig = node.getAttributeValue("container");
        ContainerContext cc = this.getContainerContextChecked(orig, session, runner, contract);
        params.put("_ContainerToFormat", cc);
        ArrayList<String> fileList = null;
        ArrayList<FileList> fileListList = null;
        ArrayList<FileSet> fileSetList = null;
        for (Element child : node.getChildren()) {
            String name = child.getName();
            if (PARAM_FILE.equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                orig = child.getText();
                String fileName = session.replaceVariables(orig);
                if (fileList == null) {
                    fileList = new ArrayList<String>(1);
                }
                fileList.add(fileName);
                continue;
            }
            if ("fileListRef".equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                orig = child.getAttributeValue("refId");
                FileList fl = this.getFileListChecked(orig, session, runner, contract, true);
                if (fileListList == null) {
                    fileListList = new ArrayList<FileList>(1);
                }
                fileListList.add(fl);
                continue;
            }
            if (!"fileSetRef".equals(name) || !this.checkIfAttribute(child, session, contract)) continue;
            orig = child.getAttributeValue("refId");
            FileSet fs = this.getFileSetChecked(orig, session, runner, contract, true);
            if (fileSetList == null) {
                fileSetList = new ArrayList<FileSet>(1);
            }
            fileSetList.add(fs);
        }
        if (fileList != null && fileList.size() > 0) {
            String[] files = new String[fileList.size()];
            files = fileList.toArray(files);
            params.put("_filesToFormat", files);
        }
        if (fileListList != null && fileListList.size() > 0) {
            FileList[] fla = new FileList[fileListList.size()];
            fla = fileListList.toArray(fla);
            params.put("_fileListsToFormat", fla);
        }
        if (fileSetList != null && fileSetList.size() > 0) {
            FileSet[] fsa = new FileSet[fileSetList.size()];
            fsa = fileSetList.toArray(fsa);
            params.put("_fileSetsToFormat", fsa);
        }
    }

    protected void handleParamNode(Element node, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return;
        }
        String orig = node.getAttributeValue(ATTR_NAME);
        String name = session.replaceVariables(orig);
        String type = PARAM_TYPE_VALUE;
        String origType = node.getAttributeValue(ATTR_TYPE);
        if (origType != null) {
            type = session.replaceVariables(origType);
        }
        orig = node.getText();
        String value = session.replaceVariables(orig);
        if (PARAM_TYPE_VALUE.equals(type)) {
            params.put("_PARAM_" + name, value);
        } else if (PARAM_TYPE_LOCATION.equals(type)) {
            ContainerContext cont = this.getContainer(session, this.getHandledNodeType(), params);
            String loc = value;
            try {
                loc = cont.getAbsoluteFilePath(loc);
            }
            catch (Exception e) {
                throw new InvalidContractException(contract, (Throwable)e);
            }
            params.put("_PARAM_" + name, loc);
        } else {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.InvalidAttribute.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), ATTR_TYPE, type, origType);
            throw new InvalidContractException(desc);
        }
    }

    protected void handleParamsNode(Element node, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        for (Element child : node.getChildren()) {
            String childName = child.getName();
            if (!PARAM_PARAM.equals(childName)) continue;
            this.handleParamNode(child, runner, session, contract, params);
        }
    }
}

