/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.FileSetImpl;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.PatternSetImpl;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.FileListNodeHandler;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class FileSetNodeHandler
extends FileListNodeHandler {
    public static final String HANDLED_NODE_TYPE = "fileSet";
    private static final String ATTR_NO_MATCHES = "failIfNoMatches";
    private static final String MSG = "com.sas.dpro.contract.parser.FileSetNodeHandler";

    public FileSetNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    protected FileSet getFileSet(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, ContractSyntaxException, InvalidContractException {
        FileList fl;
        String failStr;
        boolean fail;
        String orig = node.getAttributeValue("container");
        ContainerContext cc = this.getContainerContextChecked(orig, session, runner, contract);
        String provider = cc.getProviderName();
        String dir = cc.getDirectory();
        orig = node.getAttributeValue("subDir");
        if (orig != null) {
            String subdir = session.replaceVariables(orig);
            dir = this.addSubDir(dir, subdir, runner, contract);
        }
        String origID = node.getAttributeValue("id");
        String id = session.replaceVariables(origID);
        this.ensureNonNullAttr(id, runner, contract, "id");
        FileSetImpl fileSet = new FileSetImpl(dir, provider, id);
        FileSetNodeHandler.parseIncludeExcludes(node, runner, session, contract, this.getHandledNodeType(), (PatternSetImpl)fileSet);
        orig = node.getAttributeValue(ATTR_NO_MATCHES);
        if (orig != null && (fail = runner.ensureBoolean(failStr = session.replaceVariables(orig), this.getHandledNodeType(), ATTR_NO_MATCHES, orig)) && (fl = fileSet.getMatchingFiles()).isEmpty()) {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            String desc = DProUtil.formatString(msg, "Error.NoMatchingFiles.fmt.txt", this.getHandledNodeType(), fileSet.getID(), origID);
            throw new InvalidContractException(desc, contract);
        }
        return fileSet;
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        FileSet fileSet = this.getFileSet(node, runner, session, contract);
        session.addFileSet(fileSet);
        return new DefaultNodeHandlerResults();
    }

    public static int parseIncludeExcludes(Element node, ContractRunner runner, ContractSession session, File contract, String handledNodeType, PatternSetImpl patternSet) throws ContractSyntaxException {
        List children = node.getChildren();
        return FileSetNodeHandler.parseIncludeExcludes(children, runner, session, contract, handledNodeType, patternSet);
    }

    public static int parseIncludeExcludes(List children, ContractRunner runner, ContractSession session, File contract, String handledNodeType, PatternSetImpl patternSet) throws ContractSyntaxException {
        int added = 0;
        for (Element elem : children) {
            String pattern;
            String elemName = elem.getName();
            if (!FileSetNodeHandler.checkIfAttribute(elem, handledNodeType, session, contract)) continue;
            if ("include".equals(elemName)) {
                pattern = elem.getAttributeValue("name");
                pattern = session.replaceVariables(pattern);
                patternSet.addIncludePattern(pattern);
                ++added;
                continue;
            }
            if (!"exclude".equals(elemName)) continue;
            pattern = elem.getAttributeValue("name");
            pattern = session.replaceVariables(pattern);
            patternSet.addExcludePattern(pattern);
            ++added;
        }
        return added;
    }
}

