/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class FileListNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "fileList";
    protected static final String ATTR_ID = "id";
    private static final String CHILD_NODE_ADD_FROM_FILE = "addFromFile";
    private static final String CHILD_NODE_FILE = "file";
    private static final String ERROR_MSG = "com.sas.dpro.contract.parser.FileListNodeHandler";

    public FileListNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    protected FileListNodeHandler(String handledNodeType) {
        super(handledNodeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doAddFromFile(String handledNodeType, Element elem, ContractSession session, ContractRunner runner, File contract, ContainerContext cc, FileListImpl fileList) throws IOException, InvalidContractException {
        if (!FileListNodeHandler.checkIfAttribute(elem, handledNodeType, session, contract)) {
            return;
        }
        String fileListFile = elem.getText();
        if (fileListFile == null || fileListFile.length() == 0) {
            ResourceBundle msg = FileListNodeHandler.getErrorBundle();
            String key = "Error.EmptyFromFileSpecified.fmt.txt";
            String desc = DProUtil.formatString(msg, key, handledNodeType);
            throw new InvalidContractException(desc, contract);
        }
        fileListFile = session.replaceVariables(fileListFile);
        ContainerContext fileListCont = cc;
        String orig = elem.getAttributeValue("container");
        if (orig != null) {
            fileListCont = FileListNodeHandler.getContainerContextChecked(handledNodeType, orig, session, runner, contract);
        }
        String charset = null;
        orig = elem.getAttributeValue("characterSet");
        charset = orig != null ? session.replaceVariables(orig) : Charset.defaultCharset().name();
        InputStream in = DProUtil.getFileContents(fileListCont, fileListFile);
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in, charset));){
            String line = null;
            while ((line = r.readLine()) != null) {
                if (line.length() <= 0 || line.startsWith("#")) continue;
                fileList.add(line);
            }
        }
    }

    private static ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(ERROR_MSG);
    }

    public static void parseFileListNodes(String handledNodeType, FileListImpl fileList, ContainerContext fileListCont, Element node, ContractRunner runner, ContractSession session, File contract) throws RemoteException, ContractSyntaxException, InvalidContractException, IOException {
        List childNodes = node.getChildren();
        for (Element elem : childNodes) {
            String name = elem.getName();
            if (CHILD_NODE_FILE.equals(name)) {
                if (!FileListNodeHandler.checkIfAttribute(elem, handledNodeType, session, contract)) continue;
                String file = elem.getText();
                if (file == null || file.length() == 0) {
                    ResourceBundle msg = FileListNodeHandler.getErrorBundle();
                    String key = "Error.EmptyFileSpecified.fmt.txt";
                    String desc = DProUtil.formatString(msg, key, handledNodeType);
                    throw new InvalidContractException(desc, contract);
                }
                file = session.replaceVariables(file);
                fileList.add(file);
                continue;
            }
            if (!CHILD_NODE_ADD_FROM_FILE.equals(name)) continue;
            FileListNodeHandler.doAddFromFile(handledNodeType, elem, session, runner, contract, fileListCont, fileList);
        }
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String orig = node.getAttributeValue("container");
        ContainerContext cc = this.getContainerContextChecked(orig, session, runner, contract);
        String provider = cc.getProviderName();
        String dir = cc.getDirectory();
        orig = node.getAttributeValue("subDir");
        if (orig != null) {
            String subdir = session.replaceVariables(orig);
            dir = this.addSubDir(dir, subdir, runner, contract);
        }
        String id = node.getAttributeValue(ATTR_ID);
        id = session.replaceVariables(id);
        this.ensureNonNullAttr(id, runner, contract, ATTR_ID);
        FileListImpl fileList = new FileListImpl(dir, provider, id);
        FileListNodeHandler.parseFileListNodes(this.getHandledNodeType(), fileList, cc, node, runner, session, contract);
        session.addFileList(fileList);
        return new DefaultNodeHandlerResults();
    }
}

