/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.DirSet;
import com.sas.dpro.common.FileCollection;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class FileIterNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "fileIter";
    private static final String ATTR_DIR_LIST = "dirList";
    private static final String ATTR_DIR_SET = "dirSet";
    private static final String ATTR_FILE_LIST = "fileList";
    private static final String ATTR_FILE_SET = "fileSet";
    private static final String ATTR_FULL_PATHS = "fullPaths";
    private static final String ATTR_VARIABLE = "variable";

    public FileIterNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    protected NodeHandlerResults createNodeHandlerResults(String variable, FileCollection fc, boolean fullPaths) {
        return new FileIterNodeHandlerResults(variable, fc, fullPaths);
    }

    private void ensureUnspecified(String id, String type1, String type2, ContractRunner runner, File contract) throws InvalidContractException {
        if (id != null) {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.CannotSpecifyBoth.fmt.txt");
            desc = MessageFormat.format(desc, type1, type2, this.getHandledNodeType());
            throw new InvalidContractException(desc, contract);
        }
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        String variable = node.getAttributeValue(ATTR_VARIABLE);
        variable = session.replaceVariables(variable);
        FileCollection fc = null;
        String fileListID = node.getAttributeValue(ATTR_FILE_LIST);
        String fileSetID = node.getAttributeValue(ATTR_FILE_SET);
        String dirListID = node.getAttributeValue(ATTR_DIR_LIST);
        String dirSetID = node.getAttributeValue(ATTR_DIR_SET);
        if (fileListID != null) {
            this.ensureUnspecified(fileSetID, ATTR_FILE_LIST, ATTR_FILE_SET, runner, contract);
            this.ensureUnspecified(dirListID, ATTR_FILE_LIST, ATTR_DIR_LIST, runner, contract);
            this.ensureUnspecified(dirSetID, ATTR_FILE_LIST, ATTR_DIR_SET, runner, contract);
            fc = this.getFileListChecked(fileListID, session, runner, contract, true);
        } else if (fileSetID != null) {
            this.ensureUnspecified(dirListID, ATTR_FILE_SET, ATTR_DIR_LIST, runner, contract);
            this.ensureUnspecified(dirSetID, ATTR_FILE_SET, ATTR_DIR_SET, runner, contract);
            FileSet fs = this.getFileSetChecked(fileSetID, session, runner, contract, true);
            fc = fs.getMatchingFiles();
        } else if (dirListID != null) {
            this.ensureUnspecified(dirSetID, ATTR_DIR_LIST, ATTR_DIR_SET, runner, contract);
            fc = this.getDirListChecked(dirListID, session, runner, contract, true);
        } else if (dirSetID != null) {
            DirSet ds = this.getDirSetChecked(dirSetID, session, runner, contract, true);
            fc = ds.getMatchingDirs();
        } else {
            ResourceBundle msg = runner.getErrorBundle();
            String desc = msg.getString("Error.AttributeMissing.fmt.txt");
            String attr = "fileList/fileSet/dirList/dirSet";
            desc = MessageFormat.format(desc, attr, this.getHandledNodeType());
            throw new InvalidContractException(desc, contract);
        }
        boolean fullPaths = false;
        String fullPathsStr = node.getAttributeValue(ATTR_FULL_PATHS);
        if (fullPathsStr != null) {
            String temp = session.replaceVariables(fullPathsStr);
            fullPaths = runner.ensureBoolean(temp, this.getHandledNodeType(), ATTR_FULL_PATHS, fullPathsStr);
        }
        NodeHandlerResults res = this.createNodeHandlerResults(variable, fc, fullPaths);
        return res;
    }

    static class FileIterNodeHandlerResults
    extends DefaultNodeHandlerResults {
        private String variable;
        private FileCollection collection;
        private boolean fullPaths;

        public FileIterNodeHandlerResults(String variable, FileCollection fc, boolean fullPaths) {
            this.variable = variable;
            this.collection = fc;
            this.fullPaths = fullPaths;
        }

        @Override
        public boolean getShouldParseChildren(ContractSession s, int iter) throws InvalidContractException {
            boolean shouldParse = false;
            if (--iter < this.collection.getSize()) {
                String value = this.fullPaths ? this.collection.getAbsolute(iter) : this.collection.get(iter);
                s.setVariableValue(this.variable, value);
                shouldParse = true;
            }
            return shouldParse;
        }
    }
}

