/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.ContractSyntaxException;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.DirList;
import com.sas.dpro.common.DirListImpl;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class DirListNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "dirList";
    protected static final String ATTR_ID = "id";
    private static final String CHILD_NODE_ADD_FROM_FILE = "addFromFile";
    private static final String CHILD_NODE_DIR = "dir";
    private static final String ERROR_MSG = "com.sas.dpro.contract.parser.DirListNodeHandler";

    public DirListNodeHandler() {
        this(HANDLED_NODE_TYPE);
    }

    public DirListNodeHandler(String handledNodeType) {
        super(handledNodeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddFromFile(Element elem, ContractSession session, ContractRunner runner, File contract, ContainerContext cc, DirListImpl dirList) throws IOException, InvalidContractException {
        if (!this.checkIfAttribute(elem, session, contract)) {
            return;
        }
        String dirListFile = elem.getText();
        if (dirListFile == null || dirListFile.length() == 0) {
            ResourceBundle msg = this.getErrorBundle();
            String desc = msg.getString("Error.EmptyFromFileSpecified.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType());
            throw new InvalidContractException(desc, contract);
        }
        dirListFile = session.replaceVariables(dirListFile);
        ContainerContext dirListCont = cc;
        String orig = elem.getAttributeValue("container");
        if (orig != null) {
            dirListCont = this.getContainerContextChecked(orig, session, runner, contract);
        }
        String charset = null;
        orig = elem.getAttributeValue("characterSet");
        charset = orig != null ? session.replaceVariables(orig) : Charset.defaultCharset().name();
        InputStream in = DProUtil.getFileContents(dirListCont, dirListFile);
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in, charset));){
            String line = null;
            while ((line = r.readLine()) != null) {
                if (line.length() <= 0 || line.startsWith("#")) continue;
                dirList.add(line);
            }
        }
    }

    protected DirList getDirList(Element node, ContractRunner runner, ContractSession session, File contract) throws RemoteException, ContractSyntaxException, InvalidContractException, IOException {
        String orig = node.getAttributeValue("container");
        ContainerContext cc = this.getContainerContextChecked(orig, session, runner, contract);
        String provider = cc.getProviderName();
        String dir = cc.getDirectory();
        orig = node.getAttributeValue("subDir");
        if (orig != null) {
            String subdir = session.replaceVariables(orig);
            dir = this.addSubDir(dir, subdir, runner, contract);
        }
        String id = node.getAttributeValue(ATTR_ID);
        id = session.replaceVariables(id);
        this.ensureNonNullAttr(id, runner, contract, ATTR_ID);
        DirListImpl dirList = new DirListImpl(dir, provider, id);
        List childNodes = node.getChildren();
        for (Element elem : childNodes) {
            String name = elem.getName();
            if (CHILD_NODE_DIR.equals(name)) {
                if (!this.checkIfAttribute(elem, session, contract)) continue;
                String dirName = elem.getText();
                if (dirName == null || dirName.length() == 0) {
                    ResourceBundle msg = this.getErrorBundle();
                    String desc = msg.getString("Error.EmptyDirSpecified.fmt.txt");
                    desc = MessageFormat.format(desc, this.getHandledNodeType());
                    throw new InvalidContractException(desc, contract);
                }
                dirName = session.replaceVariables(dirName);
                dirList.add(dirName);
                continue;
            }
            if (!CHILD_NODE_ADD_FROM_FILE.equals(name)) continue;
            this.doAddFromFile(elem, session, runner, contract, cc, dirList);
        }
        return dirList;
    }

    private ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(ERROR_MSG);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        DirList dirList = this.getDirList(node, runner, session, contract);
        session.addDirList(dirList);
        return new DefaultNodeHandlerResults();
    }
}

