/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.FilterSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.Mapper;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.contract.parser.FilterSetNodeHandler;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.service.ServiceResults;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Element;

public class CopyNodeHandler
extends DefaultInternalServiceNodeHandler {
    private static final String PARAM_FILTER_SET_REF = "filterSetRef";
    private static final String MSG = "com.sas.dpro.contract.parser.CopyNodeHandler";

    public CopyNodeHandler() {
        super("Copy");
    }

    private ContainerContext checkContainerValidity(ContractSession session, String id, SerializableMap params, String errorMsg) throws InvalidContractException {
        ContainerContext container = session.getContainerContext(id);
        if (container == null) {
            ResourceBundle msg = this.getErrorBundle();
            String desc = msg.getString("Error.NoSuchContainer.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), id);
            throw new InvalidContractException(desc);
        }
        boolean willRunRemotely = false;
        String temp = (String)params.get("container");
        if (temp != null) {
            ContainerContext runInCont = session.getContainerContext(temp);
            String runInProvider = runInCont.getProviderName();
            boolean bl = willRunRemotely = !ProviderFactory.isLocalProvider(runInProvider);
        }
        if (willRunRemotely && ProviderFactory.isLocalProvider(container.getProviderName())) {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            String desc = msg.getString(errorMsg);
            desc = MessageFormat.format(desc, this.getHandledNodeType(), container.getContractID());
            throw new InvalidContractException(desc);
        }
        return container;
    }

    @Override
    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        ContainerContext ses;
        String desc;
        ResourceBundle msg;
        String fromContainerID = null;
        String toContainerID = null;
        ArrayList<FilterSet> filterSetList = new ArrayList<FilterSet>(0);
        ArrayList mapperList = null;
        boolean isToFile = false;
        for (Element elem : childNodeList) {
            String elemName = elem.getName();
            String value = session.replaceVariables(elem.getText());
            if (elemName.equals("fromFile")) {
                params.put(elemName, value);
                fromContainerID = elem.getAttributeValue("container");
                fromContainerID = session.replaceVariables(fromContainerID);
            } else if (elemName.equals("fromFileSet")) {
                params.put(elemName, value);
            } else if (elemName.equals("fromFileList")) {
                params.put(elemName, value);
            } else if (elemName.equals("fromResults")) {
                params.put(elemName, value);
            }
            if (elemName.equals("toDir")) {
                params.put(elemName, value);
                toContainerID = elem.getAttributeValue("container");
                toContainerID = session.replaceVariables(toContainerID);
            } else if (elemName.equals("toFile")) {
                isToFile = true;
                params.put(elemName, value);
                toContainerID = elem.getAttributeValue("container");
                toContainerID = session.replaceVariables(toContainerID);
            }
            if (elemName.equals("filterSet")) {
                FilterSet fs = FilterSetNodeHandler.getFilterSet(elem, this.getHandledNodeType(), runner, session, contract);
                filterSetList.add(fs);
            } else if (elemName.equals(PARAM_FILTER_SET_REF)) {
                String refid = elem.getAttributeValue("refId");
                String refid2 = session.replaceVariables(refid);
                FilterSet fs = session.getFilterSet(refid2);
                if (fs == null) {
                    ResourceBundle msg2 = runner.getErrorBundle();
                    String desc2 = msg2.getString("Error.NoSuchFilterSet.fmt.txt");
                    desc2 = MessageFormat.format(desc2, "Copy", refid2, refid);
                    throw new InvalidContractException(desc2, contract);
                }
                filterSetList.add(fs);
            }
            if (!elemName.equals("mappers")) continue;
            if (mapperList == null) {
                mapperList = new ArrayList(1);
            }
            this.parseMappersNode(elem, runner, session, contract, mapperList);
        }
        if (fromContainerID != null && toContainerID != null) {
            msg = ResourceBundle.getBundle(MSG);
            desc = msg.getString("Error.FromAndToContainersNotAllowed.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType());
            throw new InvalidContractException(desc, contract);
        }
        if (fromContainerID != null) {
            ses = this.checkContainerValidity(session, fromContainerID, params, "Error.LocalFromContainerNotAllowed.fmt.txt");
            params.put("fromContainer", ses);
        }
        if (toContainerID != null) {
            ses = this.checkContainerValidity(session, toContainerID, params, "Error.LocalToContainerNotAllowed.fmt.txt");
            params.put("toContainer", ses);
        }
        if (filterSetList.size() > 0) {
            FilterSet[] fsArray = new FilterSet[filterSetList.size()];
            fsArray = filterSetList.toArray(fsArray);
            params.put("filterSet", fsArray);
        }
        if (mapperList != null) {
            if (isToFile) {
                msg = ResourceBundle.getBundle(MSG);
                desc = msg.getString("Error.MappersAndToFile.fmt.txt");
                desc = MessageFormat.format(desc, this.getHandledNodeType());
                throw new InvalidContractException(desc);
            }
            if (mapperList.size() > 0) {
                Mapper[] array = new Mapper[mapperList.size()];
                array = mapperList.toArray(array);
                params.put("mappers", array);
            }
        }
    }

    @Override
    protected void handleExtra(Element node, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        String resultsID = (String)params.get("fromResults");
        String fileListID = (String)params.get("fromFileList");
        String fileSetID = (String)params.get("fromFileSet");
        if (resultsID != null) {
            ServiceResults results = session.getServiceResultsByID(resultsID);
            FileList fileList = results.getOutputFiles();
            params.put("fromFileList", fileList);
        } else if (fileListID != null) {
            FileList fl = this.getFileListChecked(fileListID, session, runner, contract, false);
            params.put("fromFileList", fl);
        } else if (fileSetID != null) {
            FileSet fs = this.getFileSetChecked(fileSetID, session, runner, contract, false);
            params.put("fromFileSet", fs);
        }
    }
}

