/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.FileListNodeHandler;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.service.ServiceResults;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class ChecksumNodeHandler
extends DefaultInternalServiceNodeHandler {
    public static final String HANDLED_NODE_TYPE = "Checksum";
    private static final String ATTR_FILE = "file";
    private static final String ATTR_MAKE_CHECKSUM_FILE = "makeChecksumFile";
    private static final String ATTR_VARIABLE = "variable";

    public ChecksumNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        Object[] array;
        ArrayList<String> fileList = null;
        ArrayList<String> fileMakeFileList = null;
        ArrayList<String> fileVarList = null;
        ArrayList<FileList> fileListList = null;
        ArrayList<FileSet> fileSetList = null;
        for (Element child : childNodeList) {
            String orig;
            String name = child.getName();
            if (ATTR_FILE.equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                orig = child.getText();
                String file = session.replaceVariables(orig);
                if (fileList == null) {
                    fileList = new ArrayList<String>(1);
                    fileMakeFileList = new ArrayList<String>(1);
                    fileVarList = new ArrayList<String>(1);
                }
                fileList.add(file);
                boolean makeChecksumFile = true;
                orig = child.getAttributeValue(ATTR_MAKE_CHECKSUM_FILE);
                if (orig != null) {
                    String value = session.replaceVariables(orig);
                    makeChecksumFile = runner.ensureBoolean(value, ATTR_FILE, ATTR_MAKE_CHECKSUM_FILE, orig);
                }
                fileMakeFileList.add("" + makeChecksumFile);
                orig = child.getAttributeValue(ATTR_VARIABLE);
                if (orig == null) continue;
                String varName = this.getVariableNameChecked(orig, false, session, runner, contract);
                fileVarList.add(varName);
                continue;
            }
            if ("fileList".equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                ContainerContext c = this.getContainer(session, this.getHandledNodeType(), params);
                String root = c.getDirectory();
                String provider = c.getProviderName();
                FileListImpl fl = new FileListImpl(root, provider, null);
                FileListNodeHandler.parseFileListNodes(this.getHandledNodeType(), fl, c, child, runner, session, contract);
                if (fileListList == null) {
                    fileListList = new ArrayList(1);
                }
                fileListList.add(fl);
                continue;
            }
            if ("fileListRef".equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                orig = child.getAttributeValue("refId");
                FileList fl = this.getFileListChecked(orig, session, runner, contract, true);
                if (fileListList == null) {
                    fileListList = new ArrayList<FileList>(1);
                }
                fileListList.add(fl);
                continue;
            }
            if (!"fileSetRef".equals(name) || !this.checkIfAttribute(child, session, contract)) continue;
            orig = child.getAttributeValue("refId");
            FileSet fs = this.getFileSetChecked(orig, session, runner, contract, true);
            if (fileSetList == null) {
                fileSetList = new ArrayList<FileSet>(1);
            }
            fileSetList.add(fs);
        }
        if (fileList != null) {
            int count = fileList.size();
            array = new String[count];
            array = fileList.toArray(array);
            params.put("_files", array);
            array = new String[count];
            array = (String[])fileMakeFileList.toArray(array);
            params.put("_filesMakeChecksumFiles", array);
            array = new String[count];
            array = (String[])fileVarList.toArray(array);
            params.put("_filesVarNames", array);
        }
        if (fileListList != null) {
            int count = fileListList.size();
            array = new FileList[count];
            array = (FileList[])fileListList.toArray(array);
            params.put("_fileLists", array);
        }
        if (fileSetList != null) {
            int count = fileSetList.size();
            array = new FileSet[count];
            array = (FileSet[])fileSetList.toArray(array);
            params.put("_fileSets", array);
        }
    }

    @Override
    protected void postProcessing(ContractRunner runner, ContractSession session, File contract, SerializableMap params, DefaultNodeHandlerResults results) throws ServiceFailedException, InvalidContractException {
        ServiceResults sr = results.getServiceResults();
        String stdout = sr.getStdout();
        if (stdout != null && stdout.length() > 0) {
            BufferedReader r = new BufferedReader(new StringReader(stdout));
            String line = null;
            try {
                while ((line = r.readLine()) != null) {
                    int eq = line.indexOf(61);
                    if (eq <= -1) continue;
                    String varName = line.substring(0, eq);
                    String value = line.substring(eq + 1);
                    session.setVariableValue(varName, value);
                }
                r.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

