/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultInternalServiceNodeHandler;
import com.sas.dpro.contract.parser.FileListNodeHandler;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class ChangeEncodingNodeHandler
extends DefaultInternalServiceNodeHandler {
    private static final String PARAM_FILE = "file";

    public ChangeEncodingNodeHandler() {
        super("ChangeEncoding");
    }

    @Override
    protected void handleChildNodes(List childNodeList, ContractRunner runner, ContractSession session, File contract, SerializableMap params) throws IOException, InvalidContractException {
        ArrayList<String> fileList = null;
        ArrayList<FileList> fileListList = null;
        ArrayList<FileSet> fileSetList = null;
        for (Element child : childNodeList) {
            String orig;
            String name = child.getName();
            if (PARAM_FILE.equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                if (fileList == null) {
                    fileList = new ArrayList<String>(1);
                }
                orig = child.getText();
                String file = session.replaceVariables(orig);
                fileList.add(file);
                continue;
            }
            if ("fileList".equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                ContainerContext c = this.getContainer(session, this.getHandledNodeType(), params);
                String root = c.getDirectory();
                String provider = c.getProviderName();
                FileListImpl fl = new FileListImpl(root, provider, null);
                FileListNodeHandler.parseFileListNodes(this.getHandledNodeType(), fl, c, child, runner, session, contract);
                if (fileListList == null) {
                    fileListList = new ArrayList(1);
                }
                fileListList.add(fl);
                continue;
            }
            if ("fileListRef".equals(name)) {
                if (!this.checkIfAttribute(child, session, contract)) continue;
                orig = child.getAttributeValue("refId");
                FileList fl = this.getFileListChecked(orig, session, runner, contract, true);
                if (fileListList == null) {
                    fileListList = new ArrayList<FileList>(1);
                }
                fileListList.add(fl);
                continue;
            }
            if (!"fileSetRef".equals(name) || !this.checkIfAttribute(child, session, contract)) continue;
            orig = child.getAttributeValue("refId");
            FileSet fs = this.getFileSetChecked(orig, session, runner, contract, true);
            if (fileSetList == null) {
                fileSetList = new ArrayList<FileSet>(1);
            }
            fileSetList.add(fs);
        }
        if (fileList != null && fileList.size() > 0) {
            String[] files = new String[fileList.size()];
            files = fileList.toArray(files);
            params.put("_files", files);
        }
        if (fileListList != null && fileListList.size() > 0) {
            FileList[] fla = new FileList[fileListList.size()];
            fla = fileListList.toArray(fla);
            params.put("_fileLists", fla);
        }
        if (fileSetList != null && fileSetList.size() > 0) {
            FileSet[] fsa = new FileSet[fileSetList.size()];
            fsa = fileSetList.toArray(fsa);
            params.put("_fileSets", fsa);
        }
    }
}

