/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.Macro;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.contract.parser.AbstractActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.w3c.dom.Comment;

public class CallMacroNodeHandler
extends AbstractActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "callMacro";
    private static final String ATTR_MACRO = "macro";
    private static final String HIDDEN_ATTR_CONTENT_ADDED = "__macroContentAlreadyAdded";
    private static final String MSG = "com.sas.dpro.contract.parser.CallMacroNodeHandler";

    public CallMacroNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    public static void addMacroTo(Macro macro, Element node) throws IOException {
        CallMacroNodeHandler.addMacroTo(macro, node, node.getContentSize());
    }

    public static void addMacroTo(Macro macro, Element node, int index) throws IOException {
        String xml = macro.getMacro();
        if (xml != null) {
            SAXBuilder builder = CallMacroNodeHandler.createSAXBuilder();
            StringReader reader = new StringReader(xml);
            Document doc = null;
            try {
                doc = builder.build((Reader)reader);
            }
            catch (JDOMException jde) {
                throw new IOException(jde.getMessage());
            }
            reader.close();
            Element root = doc.getRootElement();
            List content = root.getContent();
            Iterator i = content.iterator();
            while (i.hasNext()) {
                Content c = (Content)i.next();
                if (c instanceof Comment) continue;
                i.remove();
                c.detach();
                node.addContent(index++, c);
            }
        }
    }

    private static SAXBuilder createSAXBuilder() throws IOException {
        boolean validate = false;
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", validate);
        return builder;
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        if (!this.checkIfAttribute(node, session, contract)) {
            return new DefaultNodeHandlerResults();
        }
        String orig = node.getAttributeValue(ATTR_MACRO);
        Macro m = this.getMacroChecked(orig, session, runner, contract, true);
        String dproVersion = m.getDPROVersion();
        if (!runner.getSupportsDPROVersion(dproVersion)) {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            String desc = msg.getString("Error.UnsupportedMacroVersion.fmt.txt");
            desc = MessageFormat.format(desc, this.getHandledNodeType(), m.getID(), dproVersion);
            throw new InvalidContractException(desc, contract);
        }
        String alreadyAdded = node.getAttributeValue(HIDDEN_ATTR_CONTENT_ADDED);
        if (!Boolean.parseBoolean(alreadyAdded)) {
            CallMacroNodeHandler.addMacroTo(m, node);
            node.setAttribute(HIDDEN_ATTR_CONTENT_ADDED, "true");
        }
        return new CallMacroNodeHandlerResults();
    }

    private static class CallMacroNodeHandlerResults
    extends DefaultNodeHandlerResults {
        private CallMacroNodeHandlerResults() {
        }

        @Override
        public boolean getCouldParseChildren(ContractSession session) {
            return true;
        }

        @Override
        public boolean getShouldParseChildren(ContractSession session, int iter) throws InvalidContractException {
            return iter == 1;
        }
    }
}

