/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileCollection;
import com.sas.dpro.common.FileContents;
import com.sas.dpro.common.FileContentsFactory;
import com.sas.dpro.common.FileSetImpl;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.NodeHandlerException;
import com.sas.dpro.common.PatternSetImpl;
import com.sas.dpro.contract.messages.ResultsMessage;
import com.sas.dpro.contract.messages.ResultsMessageImpl;
import com.sas.dpro.contract.parser.AbstractResultsActionNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.contract.parser.DefaultNodeHandlerResults;
import com.sas.dpro.contract.parser.FileSetNodeHandler;
import com.sas.dpro.contract.parser.NodeHandlerResults;
import com.sas.dpro.controller.ContractSession;
import com.sas.dpro.controller.HonorContractContext;
import com.sas.dpro.provider.ProviderFactory;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class AddToResultsNodeHandler
extends AbstractResultsActionNodeHandler {
    public static final String HANDLED_NODE_TYPE = "addToResults";
    private static final String ELEM_OUTPUT_FILES = "outputFiles";
    private static final String PARAM_FILESET = "fileSet";

    public AddToResultsNodeHandler() {
        super(HANDLED_NODE_TYPE);
    }

    @Override
    public NodeHandlerResults handleNode(Element node, ContractRunner runner, ContractSession session, File contract) throws IOException, RemoteException, InvalidContractException, NodeHandlerException {
        HonorContractContext hcc = session.getHonorContractContext();
        String orig = node.getAttributeValue("id");
        String id = session.replaceVariables(orig);
        StringBuilder paramXML = new StringBuilder("<params>\n");
        XMLOutputter outputter = new XMLOutputter();
        for (Element child : node.getChildren()) {
            String childName = child.getName();
            if ("params".equals(childName)) {
                for (Element e : child.getChildren()) {
                    String eName = e.getName();
                    if (!"param".equals(eName)) continue;
                    orig = e.getAttributeValue("name");
                    String paramName = session.replaceVariables(orig);
                    e.setAttribute("name", paramName);
                    orig = e.getText();
                    String value = session.replaceVariables(orig);
                    e.setText(value);
                    String str = outputter.outputString(e);
                    paramXML.append('\t').append(str).append('\n');
                }
                continue;
            }
            if (!ELEM_OUTPUT_FILES.equals(childName)) continue;
            FileCollection sendBackFL = null;
            for (Element grandkid : child.getChildren()) {
                String gkName = grandkid.getName();
                if (!PARAM_FILESET.equals(gkName)) continue;
                orig = grandkid.getAttributeValue("container");
                ContainerContext cc = this.getContainerContextChecked(orig, session, runner, contract);
                String provider = cc.getProviderName();
                if (!ProviderFactory.isLocalProvider(provider)) {
                    ResourceBundle msg = runner.getErrorBundle();
                    String desc = msg.getString("Error.ContainerMustBeLocal.fmt.txt");
                    desc = MessageFormat.format(desc, this.getHandledNodeType(), session.replaceVariables(orig), provider, ProviderFactory.getLocalProviderName());
                    throw new InvalidContractException(desc, contract);
                }
                String dir = cc.getDirectory();
                orig = grandkid.getAttributeValue("subDir");
                if (orig != null) {
                    String subdir = session.replaceVariables(orig);
                    dir = this.addSubDir(dir, subdir, runner, contract);
                }
                FileSetImpl fileSet = new FileSetImpl(dir, provider, null);
                FileSetNodeHandler.parseIncludeExcludes(grandkid, runner, session, contract, this.getHandledNodeType(), (PatternSetImpl)fileSet);
                sendBackFL = fileSet.getMatchingFiles();
            }
            for (int j = 0; j < sendBackFL.getSize(); ++j) {
                ResultsMessageImpl rm = new ResultsMessageImpl(hcc, 1);
                String name = sendBackFL.get(j);
                rm.setResultID(id);
                rm.setResultXML(null);
                File file = new File(sendBackFL.getAbsolute(j));
                if (!file.isFile()) {
                    ResourceBundle msg = runner.getErrorBundle();
                    String key = "Error.FileDoesNotExist2.fmt.txt";
                    String desc = DProUtil.formatString(msg, key, this.getHandledNodeType(), sendBackFL.getProvider(), file.getAbsolutePath());
                    throw new NodeHandlerException(desc);
                }
                long fileSize = file.length();
                boolean compress = DProUtil.getShouldCompressFileOnTransfer(null, fileSize);
                FileContents fc = FileContentsFactory.createFileContents(file, compress);
                ResultsMessage.OutputFile of = rm.createOutputFile(name, fc);
                rm.setOutputFile(of);
                session.getMessageQueue().enqueue(rm);
            }
        }
        paramXML.append("</params>").append("\n\n");
        ResultsMessageImpl rm = new ResultsMessageImpl(hcc, 1);
        rm.setResultID(id);
        rm.setResultXML(paramXML.toString());
        session.getMessageQueue().enqueue(rm);
        DefaultNodeHandlerResults results = new DefaultNodeHandlerResults();
        return results;
    }
}

