/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.parser;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InvalidContractException;
import com.sas.dpro.common.RCRules;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.contract.parser.AbstractContractNodeHandler;
import com.sas.dpro.contract.parser.ContractRunner;
import com.sas.dpro.service.ServiceResults;
import java.io.File;
import java.util.ResourceBundle;

abstract class AbstractServiceNodeHandler
extends AbstractContractNodeHandler {
    protected static final String ATTR_COMMON_FAIL_IF_FAILURE = "failIfFailure";
    protected static final String ATTR_COMMON_FAIL_IF_TIMEOUT = "failIfTimeOut";
    protected static final String ATTR_COMMON_MACRO_ID = "macroID";
    protected static final String ATTR_COMMON_RC = "rc";
    protected static final String ATTR_COMMON_RC_VAR = "rcVar";

    public AbstractServiceNodeHandler(String handledNodeType) {
        super(handledNodeType);
    }

    protected String checkReturnCode(String serviceName, ContractRunner runner, File contract, ServiceResults results, String rcRulesStr) throws InvalidContractException, ServiceFailedException {
        String toReturn = results.getStatusString();
        int status = results.getStatus();
        if (status == 0) {
            int rc = results.getReturnCode();
            RCRules rcRules = this.createRCRules(rcRulesStr, contract);
            if (rcRules.isUnexpectedRC(rc)) {
                ResourceBundle msg = runner.getErrorBundle();
                String key = "Error.UnexpectedReturnCode.fmt.txt";
                String desc = DProUtil.formatString(msg, key, serviceName, new Integer(rc));
                ServiceFailedException sfe = new ServiceFailedException(desc);
                sfe.setServiceResults(results);
                sfe.setCommandExecuted(results.getCommandExecuted());
                throw sfe;
            }
        }
        return toReturn;
    }
}

