/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.contract.messages;

import com.sas.dpro.common.FileContents;
import com.sas.dpro.contract.messages.AbstractMessage;
import com.sas.dpro.contract.messages.ResultsMessage;
import com.sas.dpro.controller.HonorContractContext;
import java.io.Serializable;

public class ResultsMessageImpl
extends AbstractMessage
implements ResultsMessage {
    private String resultID;
    private String resultsType;
    private String resultXML;
    private ResultsMessage.OutputFile[] outputFiles;
    private int type;
    private static final long serialVersionUID = 1L;

    public ResultsMessageImpl(HonorContractContext hcc, int type) {
        super(hcc);
        this.setType(type);
    }

    public ResultsMessage.OutputFile createOutputFile(String name, FileContents fc) {
        return new OutputFileImpl(name, fc);
    }

    @Override
    public ResultsMessage.OutputFile[] getOutputFiles() {
        return this.outputFiles;
    }

    @Override
    public String getResultID() {
        return this.resultID;
    }

    @Override
    public String getResultXML() {
        return this.resultXML;
    }

    @Override
    public String getResultsType() {
        return this.resultsType;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isUpdate() {
        return this.type == 1 || this.type == 2;
    }

    private static final boolean isValidType(int type) {
        return type == 3 || type == 0 || type == 1 || type == 2;
    }

    public void setOutputFile(ResultsMessage.OutputFile file) {
        this.setOutputFiles(new ResultsMessage.OutputFile[]{file});
    }

    public void setOutputFiles(ResultsMessage.OutputFile[] files) {
        this.outputFiles = files;
    }

    public void setResultID(String id) {
        this.resultID = id;
    }

    public void setResultXML(String xml) {
        this.resultXML = xml;
    }

    public void setResultsType(String type) {
        this.resultsType = type;
    }

    public void setType(int type) {
        if (!ResultsMessageImpl.isValidType(type)) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        this.type = type;
    }

    public String toString() {
        return "[ResultsMessageImpl: hcc=" + this.getHonorContractContext() + "; resultsType=" + this.getResultsType() + "; type=" + this.getType() + "; resultID=" + this.getResultID() + "]";
    }

    public static class OutputFileImpl
    implements ResultsMessage.OutputFile,
    Serializable {
        private static final long serialVersionUID = 1L;
        public FileContents contents;
        public String name;

        public OutputFileImpl(String name, FileContents contents) {
            this.name = name;
            this.contents = contents;
        }

        @Override
        public FileContents getContents() {
            return this.contents;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

