/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlUtil {
    public static final String ENCODING = "encoding";
    public static final String ENCODING_UTF_8 = "utf-8";
    public static final String ENCODING_BASE64 = "base64";

    private XmlUtil() {
    }

    public static final void addTagWithTextContent(Document doc, Element parent, String name, String value) {
        Element elem = doc.createElement(name);
        if (value != null) {
            if (XmlUtil.containsInvalidXmlChars(value)) {
                Base64 base64 = new Base64();
                try {
                    byte[] bytes = value.getBytes("UTF-8");
                    byte[] encoded = base64.encode(bytes);
                    String text = new String(encoded, "UTF-8");
                    elem.appendChild(doc.createTextNode(text));
                    elem.setAttribute(ENCODING, ENCODING_BASE64);
                }
                catch (UnsupportedEncodingException uee) {
                    uee.printStackTrace();
                }
            } else {
                elem.setAttribute(ENCODING, ENCODING_UTF_8);
                elem.appendChild(doc.createCDATASection(value));
            }
        }
        parent.appendChild(elem);
    }

    private static boolean containsInvalidXmlChars(String text) {
        boolean invalid = false;
        if (text != null && text.length() > 0) {
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff') continue;
                invalid = true;
                break;
            }
        }
        return invalid;
    }

    public static final String getAllChildText(Element elem) {
        String encoding = elem.getAttribute(ENCODING);
        if (!ENCODING_UTF_8.equals(encoding) && !ENCODING_BASE64.equals(encoding)) {
            encoding = ENCODING_UTF_8;
        }
        boolean base64 = ENCODING_BASE64.equals(encoding);
        String text = null;
        NodeList childNodes = elem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!(child instanceof Text)) continue;
            String value = child.getNodeValue();
            if (base64) {
                try {
                    byte[] binary = value.getBytes("UTF-8");
                    byte[] bytes = Base64.decodeBase64((byte[])binary);
                    value = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException use) {
                    use.printStackTrace();
                }
            }
            text = text == null ? value : text + value;
        }
        return text;
    }
}

