/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.DProUtil;
import java.util.regex.Pattern;

public class PatternSetUtil {
    public static final String MATCH_ALL_KEY = "**";

    protected PatternSetUtil() {
    }

    private static Pattern createPattern(String filenameSpec) {
        char[] specChars = filenameSpec.toCharArray();
        int count = specChars.length;
        StringBuilder buf = new StringBuilder();
        block4: for (int i = 0; i < count; ++i) {
            switch (specChars[i]) {
                case '*': {
                    buf.append(".*");
                    continue block4;
                }
                case '?': {
                    buf.append('.');
                    continue block4;
                }
                default: {
                    if (!Character.isLetterOrDigit(specChars[i])) {
                        buf.append('\\');
                    }
                    buf.append(specChars[i]);
                }
            }
        }
        int flags = DProUtil.osIsWindows() ? 66 : 0;
        return Pattern.compile(buf.toString(), flags);
    }

    protected static Pattern[] getPatternsForFilePath(String filePath) {
        char[] chars = filePath.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\\') continue;
            chars[i] = 47;
        }
        String[] pieces = new String(chars).split("/");
        int pieceCount = pieces.length;
        Pattern[] patterns = new Pattern[pieceCount];
        for (int i = 0; i < pieceCount; ++i) {
            patterns[i] = pieces[i].equals(MATCH_ALL_KEY) ? null : PatternSetUtil.createPattern(pieces[i]);
        }
        return patterns;
    }

    protected static boolean possiblyRemove(String[] fileElems, int e, Pattern[] patterns, int p) {
        int elemCount = fileElems.length;
        int patternCount = patterns.length;
        for (int j = e; j < elemCount; ++j) {
            if (patterns[p] == null) {
                if (p == patternCount - 1) {
                    if (j != elemCount - 1) continue;
                    return true;
                }
                if (j < elemCount - 1) {
                    if (PatternSetUtil.possiblyRemove(fileElems, j + 1, patterns, p)) {
                        return true;
                    }
                    if (patterns[p + 1] == null) continue;
                    if (PatternSetUtil.possiblyRemove(fileElems, j + 1, patterns, p + 1)) {
                        return true;
                    }
                    return PatternSetUtil.possiblyRemove(fileElems, j, patterns, p + 1);
                }
                return p + 1 == patternCount - 1 && (patterns[p + 1] == null || patterns[p + 1].matcher(fileElems[j]).matches());
            }
            if (patterns[p].matcher(fileElems[j]).matches()) {
                if (p == patternCount - 1) {
                    return j == elemCount - 1;
                }
                ++p;
                continue;
            }
            return false;
        }
        return false;
    }
}

