/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class MetadataServerConnection {
    private String host;
    private String port;
    private CMetadata repos;
    private MdOMRConnection workspace;
    private static final String MSG = "com.sas.dpro.common.MetadataServerConnection";

    public MetadataServerConnection(String host, String port, String userid, String password) throws RemoteException, MdException {
        this.host = host;
        this.port = port;
        this.workspace = Workspace.getMdFactory().getConnection();
        this.workspace.makeOMRConnection(host, port, userid, password);
        this.repos = this.getFoundationRepository();
        if (this.repos == null) {
            String desc = this.getErrorBundle().getString("Error.NoRepositories.txt");
            throw new RemoteException(desc);
        }
    }

    public MetadataServerConnection(String host, String port, CMetadata repos) {
        this.host = host;
        this.port = port;
        this.repos = repos;
        if (repos == null) {
            throw new NullPointerException();
        }
    }

    public synchronized void disconnect() throws RemoteException {
        if (this.workspace != null) {
            this.workspace.closeOMRConnection();
            this.workspace = null;
        }
    }

    private ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    protected CMetadata getFoundationRepository() throws MdException, RemoteException {
        if (this.workspace == null) {
            return null;
        }
        List repositories = Workspace.getMdFactory().getOMIUtil().getRepositories();
        if (repositories == null || repositories.size() == 0) {
            return null;
        }
        return (CMetadata)repositories.get(0);
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public List getRegisteredProviders() throws MdException, RemoteException {
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        String options = "<XMLSELECT search=\"ServiceComponent[@Name='Deployment Tester']\"/>";
        List trList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, this.repos.getFQID(), "ServiceComponent", 388, options);
        ArrayList<String> providerList = new ArrayList<String>(3);
        for (ServiceComponent comp : trList) {
            AssociationList pcList = comp.getProviderConnections();
            for (TCPIPConnection con : pcList) {
                String provider = con.getHostName() + ":" + con.getPort();
                providerList.add(provider);
            }
        }
        store.dispose();
        return providerList;
    }
}

