/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.Mapper;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MapperUtil {
    private static final String PROPERTY_DEBUG_MAPPERS = "com.sas.dpro.common.Mapper.debug";
    private static ResourceBundle errorMsg;
    private static final String ERROR_MSG = "com.sas.dpro.common.MapperUtil";
    private static final String[] TYPE_STRINGS;

    private MapperUtil() {
    }

    public static String applyMappers(String str, Mapper[] mappers) throws Exception {
        boolean debugMappers = Boolean.getBoolean(PROPERTY_DEBUG_MAPPERS);
        MapperUtil.debugMsg(debugMappers, "MapperUtil.applyMappers(): entering, str==" + str);
        if (mappers == null) {
            MapperUtil.debugMsg(debugMappers, "MapperUtil.applyMappers(): exiting (no mappers)");
            return str;
        }
        block4: for (int i = 0; i < mappers.length; ++i) {
            switch (mappers[i].getType()) {
                case 0: {
                    StringBuffer sb;
                    Matcher m;
                    MapperUtil.debugMsg(debugMappers, "... type glob");
                    String from = mappers[i].getFrom();
                    MapperUtil.debugMsg(debugMappers, "... ... from == " + from);
                    int fromStar = from.indexOf(42);
                    if (fromStar > -1) {
                        MapperUtil.debugMsg(debugMappers, "... ... fromStar==" + fromStar);
                        if (from.indexOf(42, fromStar + 1) > -1) {
                            ResourceBundle msg = MapperUtil.getErrorBundle();
                            String desc = msg.getString("Error.GlobPattern.StarCount.fmt.txt");
                            desc = MessageFormat.format(desc, "from");
                            throw new Exception(desc);
                        }
                        from = Pattern.quote(from.substring(0, fromStar)) + "(.*)" + Pattern.quote(from.substring(fromStar + 1));
                        MapperUtil.debugMsg(debugMappers, "... ... ... new from == " + from);
                    }
                    int flags = 0;
                    Pattern p = Pattern.compile(from, flags);
                    String to = mappers[i].getTo();
                    MapperUtil.debugMsg(debugMappers, "... ... to== " + to);
                    int toStar = to.indexOf(42);
                    if (toStar > -1) {
                        String desc;
                        ResourceBundle msg;
                        MapperUtil.debugMsg(debugMappers, "... ... toStar==" + toStar);
                        if (fromStar == -1) {
                            msg = MapperUtil.getErrorBundle();
                            desc = msg.getString("Error.GlobPattern.StarInToButNotFrom.fmt.txt");
                            desc = MessageFormat.format(desc, to, from);
                            throw new Exception(desc);
                        }
                        if (to.indexOf(42, toStar + 1) > -1) {
                            msg = MapperUtil.getErrorBundle();
                            desc = msg.getString("Error.GlobPattern.StarCount.fmt.txt");
                            desc = MessageFormat.format(desc, "to");
                            throw new Exception(desc);
                        }
                        to = Matcher.quoteReplacement(to.substring(0, toStar)) + "$1" + Matcher.quoteReplacement(to.substring(toStar + 1));
                        MapperUtil.debugMsg(debugMappers, "... ... ... new to == " + to);
                    }
                    if ((m = p.matcher(str)).find()) {
                        sb = new StringBuffer();
                        m.appendReplacement(sb, to);
                        m.appendTail(sb);
                        str = sb.toString();
                        MapperUtil.debugMsg(debugMappers, "*** match - new str == " + str);
                        continue block4;
                    }
                    MapperUtil.debugMsg(debugMappers, "*** no match");
                    continue block4;
                }
                case 1: {
                    StringBuffer sb;
                    MapperUtil.debugMsg(debugMappers, "... type regex");
                    int flags = 0;
                    Pattern p = Pattern.compile(mappers[i].getFrom(), flags);
                    Matcher m = p.matcher(str);
                    if (m.find()) {
                        sb = new StringBuffer();
                        m.appendReplacement(sb, mappers[i].getTo());
                        m.appendTail(sb);
                        str = sb.toString();
                        MapperUtil.debugMsg(debugMappers, "*** match - new str == " + str);
                        continue block4;
                    }
                    MapperUtil.debugMsg(debugMappers, "*** no match");
                }
            }
        }
        MapperUtil.debugMsg(debugMappers, "MapperUtil.applyMappers(): exiting; str == " + str);
        return str;
    }

    private static final void debugMsg(boolean debug, String msg) {
        if (debug) {
            System.err.println("[MapperUtil DEBUG]: " + msg);
        }
    }

    private static synchronized ResourceBundle getErrorBundle() {
        if (errorMsg == null) {
            errorMsg = ResourceBundle.getBundle(ERROR_MSG);
        }
        return errorMsg;
    }

    public static int getMapperType(String typeStr) {
        int type = -1;
        if (typeStr != null) {
            for (int i = 0; i < TYPE_STRINGS.length; ++i) {
                if (!typeStr.equals(TYPE_STRINGS[i])) continue;
                type = i;
                break;
            }
        }
        return type;
    }

    static {
        TYPE_STRINGS = new String[]{"glob", "regex"};
    }
}

