/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import java.io.File;
import java.util.ResourceBundle;

public class InvalidContractException
extends Exception {
    private File contractFile;
    private static final String MSG = "com.sas.dpro.common.InvalidContractException";
    private static final long serialVersionUID = 1L;

    public InvalidContractException(String message) {
        super(message);
    }

    public InvalidContractException(Throwable cause) {
        super(cause);
    }

    public InvalidContractException(File contractFile, Throwable cause) {
        super(cause);
        this.contractFile = contractFile;
    }

    public InvalidContractException(String message, File contractFile) {
        super(message);
        this.contractFile = contractFile;
    }

    public InvalidContractException(String message, File contractFile, Throwable cause) {
        super(message, cause);
        this.contractFile = contractFile;
    }

    public File getContractFile() {
        return this.contractFile;
    }

    public String getContractFilePath() {
        String path = null;
        if (this.contractFile != null) {
            path = this.contractFile.getAbsolutePath();
        } else {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            path = msg.getString("UnknownContract.txt");
        }
        return path;
    }

    @Override
    public String getMessage() {
        Throwable cause;
        String message = super.getMessage();
        if (message == null && (cause = this.getCause()) != null) {
            message = cause.getMessage();
        }
        return message;
    }
}

