/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.FilterSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public class FilterSetUtil {
    private FilterSetUtil() {
    }

    public static void applyFilters(BufferedReader in, PrintWriter out, FilterSet[] filterSets) throws IOException {
        int fsCount = filterSets == null ? 0 : filterSets.length;
        String line = null;
        while ((line = in.readLine()) != null) {
            for (int i = 0; i < fsCount; ++i) {
                int endPos;
                FilterSet fs = filterSets[i];
                int filterCount = fs.getFilterCount();
                String beg = fs.getBeginToken();
                int begLen = beg.length();
                String end = fs.getEndToken();
                int index = 0;
                while ((index = line.indexOf(beg, index)) > -1 && (endPos = line.indexOf(end, index + begLen)) != -1) {
                    String temp = line.substring(index + begLen, endPos);
                    boolean replaced = false;
                    for (int j = 0; j < filterCount; ++j) {
                        FilterSet.Filter f = fs.getFilter(j);
                        if (!f.getToken().equals(temp)) continue;
                        line = line.substring(0, index) + f.getValue() + line.substring(endPos + end.length());
                        index += f.getValue().length() + end.length();
                        replaced = true;
                        break;
                    }
                    if (replaced) continue;
                    index += begLen;
                }
            }
            out.println(line);
        }
    }
}

