/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.FilterSet;
import com.sas.dpro.common.FilterSetUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;

public class FilterSetImpl
implements FilterSet,
Serializable {
    private String beginToken;
    private String endToken;
    private FilterSet.Filter[] filters;
    private static final String DEFAULT_TOKEN_DELIMITER = "@";
    private static final long serialVersionUID = 1L;

    public FilterSetImpl() {
        this.setBeginToken(DEFAULT_TOKEN_DELIMITER);
        this.setEndToken(DEFAULT_TOKEN_DELIMITER);
        this.filters = new FilterSet.Filter[0];
    }

    public void addFilter(String token, String value) {
        FilterSet.Filter[] temp = new FilterSet.Filter[this.filters.length + 1];
        System.arraycopy(this.filters, 0, temp, 0, this.filters.length);
        temp[temp.length - 1] = new FilterImpl(token, value);
        this.filters = temp;
    }

    @Override
    public String getBeginToken() {
        return this.beginToken;
    }

    @Override
    public String getEndToken() {
        return this.endToken;
    }

    @Override
    public FilterSet.Filter getFilter(int index) {
        return this.filters[index];
    }

    @Override
    public int getFilterCount() {
        return this.filters.length;
    }

    public void recurse() throws IOException {
        boolean modified;
        int count = this.getFilterCount();
        FilterSet[] filterSets = new FilterSet[]{this};
        do {
            modified = false;
            for (int i = 0; i < count; ++i) {
                FilterSet.Filter filter = this.getFilter(i);
                BufferedReader r = new BufferedReader(new StringReader(filter.getValue()));
                StringWriter sw = new StringWriter();
                PrintWriter w = new PrintWriter(sw);
                FilterSetUtil.applyFilters(r, w, filterSets);
                String result = sw.toString();
                if (result.endsWith("\r\n")) {
                    result = result.substring(0, result.length() - 2);
                } else if (result.endsWith("\n")) {
                    result = result.substring(0, result.length() - 1);
                }
                if (result.equals(filter.getValue())) continue;
                ((FilterImpl)filter).setValue(result);
                modified = true;
            }
        } while (modified);
    }

    public void setBeginToken(String beginToken) {
        this.beginToken = beginToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    static class FilterImpl
    implements FilterSet.Filter,
    Serializable {
        private String token;
        private String value;
        private static final long serialVersionUID = 1L;

        public FilterImpl(String token, String value) {
            this.setToken(token);
            this.setValue(value);
        }

        @Override
        public String getToken() {
            return this.token;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

