/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.DProUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom2.Element;

public abstract class FileParserBase {
    private Properties variables;
    private static final String APPEND = "append";
    private static final String ARG = "arg";
    protected static final String NAME = "name";
    protected static final String PROPERTIES_FILE = "loadPropertiesFile";
    protected static final String RELATIVE_PATH = "relativePath";
    private static final String VAR = "var";
    protected static final String VERSION = "version";
    protected static final String TYPE = "type";
    protected static final String TYPE_TEXT = "text";
    protected static final String TYPE_LOCATION = "location";
    protected static final String RELATIVE_TO = "relativeTo";
    protected static final String RELATIVE_TO_THIS_FILE = "this";
    protected static final String RELATIVE_TO_COMMAND = "command";
    private static final String LOAD = "load";
    private static final String LOAD_ON_UNIX = "loadOnUnix";
    private static final String LOAD_ON_WINDOWS = "loadOnWindows";
    private static final String LOAD_ON_ZOS = "loadOnZOS";
    protected static final String UNCONFIGURED_PARAM_PREFIX_1 = "!unconfigured_";
    protected static final String UNCONFIGURED_PARAM_PREFIX_2 = "@unconfigured_";

    protected void debugPrint(String text) {
        if (Boolean.getBoolean(this.getDebugProperty())) {
            System.out.println(this.getDebugHeader() + ": " + text);
        }
    }

    protected String ensureAbsolute(String command) {
        File temp = new File(command);
        if (!temp.isAbsolute()) {
            temp = new File(this.getXMLFile().getParentFile(), command);
            try {
                command = temp.getCanonicalPath();
            }
            catch (IOException ioe) {
                command = temp.getAbsolutePath();
            }
        }
        return DProUtil.fixSlashes(command);
    }

    protected abstract String getDebugHeader();

    protected abstract String getDebugProperty();

    private String getVariableValue(String varName) {
        String value = "${" + varName + "}";
        if (this.variables != null && this.variables.get(varName) != null) {
            value = (String)this.variables.get(varName);
        }
        return value;
    }

    protected abstract File getXMLFile();

    protected List handleArgsNode(Element elem, String command) throws IOException {
        ArrayList<String> argList = null;
        for (Element child : elem.getChildren()) {
            String childName = child.getName();
            if (!ARG.equals(childName)) continue;
            String arg = child.getText();
            arg = this.replaceVariables(arg);
            String type = child.getAttributeValue(TYPE);
            if (type == null) {
                type = TYPE_TEXT;
            }
            if (TYPE_LOCATION.equals(type = this.replaceVariables(type))) {
                String origArg = arg;
                String relativeTo = child.getAttributeValue(RELATIVE_TO);
                if (relativeTo == null) {
                    relativeTo = RELATIVE_TO_THIS_FILE;
                }
                File newArgFile = null;
                if (RELATIVE_TO_THIS_FILE.equals(relativeTo)) {
                    File parentDir = this.getXMLFile().getParentFile();
                    newArgFile = new File(parentDir, arg);
                } else if (RELATIVE_TO_COMMAND.equals(relativeTo)) {
                    File commandDir = new File(command).getParentFile();
                    newArgFile = new File(commandDir, arg);
                } else {
                    throw new IOException("Invalid 'relativeTo' for 'arg': " + relativeTo);
                }
                try {
                    arg = newArgFile.getCanonicalPath();
                }
                catch (IOException ioe) {
                    arg = newArgFile.getAbsolutePath();
                    arg = DProUtil.fixSlashes(arg);
                }
                this.debugPrint("... arg (relative to: " + relativeTo + "): \"" + origArg + "\" => \"" + arg + "\"");
            } else if (TYPE_TEXT.equals(type)) {
                this.debugPrint("... arg: \"" + arg + "\"");
            } else {
                throw new IOException("Invalid 'type' for 'arg': " + type);
            }
            if (argList == null) {
                argList = new ArrayList<String>(1);
            }
            argList.add(arg);
        }
        return argList;
    }

    protected boolean handleEnvVarsNode(Element elem, Map envVars) {
        String temp = elem.getAttributeValue(APPEND);
        temp = this.replaceVariables(temp);
        boolean append = Boolean.parseBoolean(temp);
        for (Element child : elem.getChildren()) {
            String childName = child.getName();
            if (!VAR.equals(childName)) continue;
            String name = child.getAttributeValue(NAME);
            name = this.replaceVariables(name);
            String value = child.getText();
            value = this.replaceVariables(value);
            envVars.put(name, value);
        }
        return append;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePropertiesFileNode(Element elem) throws IOException {
        if (!this.shouldLoad(elem, PROPERTIES_FILE)) {
            return;
        }
        String fileName = elem.getText();
        fileName = this.replaceVariables(fileName);
        fileName = this.ensureAbsolute(fileName);
        this.debugPrint("Loading properties file: " + fileName);
        if (this.variables == null) {
            this.variables = new Properties();
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileName));){
            this.variables.load(in);
        }
    }

    protected String replaceVariables(String text) {
        if (text == null) {
            return null;
        }
        if (this.variables == null || this.variables.size() == 0) {
            return text;
        }
        char[] chars = text.toCharArray();
        int charCount = chars.length;
        StringBuilder buffer = new StringBuilder();
        int pos = 0;
        block3: for (int i = 0; i < charCount - 1; ++i) {
            if (chars[i] != '$') continue;
            switch (chars[++i]) {
                case '{': {
                    buffer.append(chars, pos, i - pos - 1);
                    pos = i - 1;
                    while (++i < charCount) {
                        if (chars[i] != '}') continue;
                        String var = new String(chars, pos + 2, i - (pos + 2));
                        String replacement = this.getVariableValue(var);
                        buffer.append(replacement);
                        pos = i + 1;
                        continue block3;
                    }
                    continue block3;
                }
            }
        }
        if (pos < charCount) {
            buffer.append(chars, pos, charCount - pos);
        }
        return buffer.toString();
    }

    protected boolean shouldLoad(Element elem, String name) {
        boolean load = true;
        String loadStr = elem.getAttributeValue(LOAD);
        if (loadStr != null) {
            loadStr = this.replaceVariables(loadStr);
            load = Boolean.parseBoolean(loadStr);
        }
        if (load) {
            loadStr = DProUtil.osIsWindows() ? LOAD_ON_WINDOWS : (DProUtil.osIsZOS() ? LOAD_ON_ZOS : LOAD_ON_UNIX);
            if ((loadStr = elem.getAttributeValue(loadStr)) != null) {
                loadStr = this.replaceVariables(loadStr);
                load = Boolean.parseBoolean(loadStr);
            }
        }
        this.debugPrint("Loading '" + name + "'?: " + load);
        return load;
    }
}

