/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileContents;
import com.sas.dpro.common.FileContentsImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileContentsFactory {
    public static final String PROPERTY_DEBUG_CREATE_FILE_CONTENTS = "com.sas.dpro.common.FileContentsFactory.debug";
    private static final int READ_BUF_SIZE = 8192;

    private FileContentsFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileContents createFileContents(byte[] bytes, boolean compress) throws IOException {
        FileContentsFactory.debugPrint("Starting createFileContents(byte[], boolean)");
        long start = System.nanoTime();
        FileContentsImpl fc = null;
        if (bytes == null) {
            throw new IOException("bytes parameter cannot be null");
        }
        FileContentsFactory.debugPrint("... Compress: " + compress);
        if (compress) {
            FileContentsFactory.debugPrint("... ... Actual byte count:     " + bytes.length);
            try (BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(bytes));){
                CRC32 crc32 = new CRC32();
                bytes = FileContentsFactory.doCompress(in, "FileContents", crc32);
                FileContentsFactory.debugPrint("... ... Compressed byte count: " + bytes.length);
                FileContentsFactory.debugPrint("... ... CRC-32:                " + crc32.getValue());
                fc = new FileContentsImpl(bytes, true);
                fc.setUncompressedCRC32(crc32.getValue());
            }
        } else {
            fc = new FileContentsImpl(bytes, false);
        }
        long time = System.nanoTime() - start;
        float secs = DProUtil.nanosToSeconds(time);
        FileContentsFactory.debugPrint("Exiting createFileContents (" + secs + ") seconds");
        return fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileContents createFileContents(File file, boolean compress) throws IOException {
        FileContentsFactory.debugPrint("Starting createFileContents(File, boolean)");
        long start = System.nanoTime();
        FileContentsImpl fc = null;
        if (file == null) {
            throw new IOException("file parameter cannot be null");
        }
        if (!file.isFile()) {
            throw new IOException("File " + file.getAbsolutePath() + " is not a regular file");
        }
        FileContentsFactory.debugPrint("... File: " + file.getAbsolutePath());
        FileContentsFactory.debugPrint("... Compress: " + compress);
        if (compress) {
            FileContentsFactory.debugPrint("... ... Actual file size: " + file.length());
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                CRC32 crc32 = new CRC32();
                byte[] bytes = FileContentsFactory.doCompress(in, file.getName(), crc32);
                FileContentsFactory.debugPrint("... ... Compressed size:  " + bytes.length);
                FileContentsFactory.debugPrint("... ... CRC-32:           " + crc32.getValue());
                fc = new FileContentsImpl(bytes, true);
                fc.setUncompressedCRC32(crc32.getValue());
            }
        }
        int length = (int)file.length();
        byte[] bytes = new byte[length];
        try (BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
             DataInputStream in = new DataInputStream(bin);){
            in.readFully(bytes);
        }
        fc = new FileContentsImpl(bytes, false);
        long time = System.nanoTime() - start;
        float secs = DProUtil.nanosToSeconds(time);
        FileContentsFactory.debugPrint("Exiting createFileContents (" + secs + ") seconds");
        return fc;
    }

    private static void debugPrint(String msg) {
        if (Boolean.getBoolean(PROPERTY_DEBUG_CREATE_FILE_CONTENTS)) {
            System.err.println("[DEBUG FileContentsFactory]: " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] doCompress(InputStream in, String entryName, CRC32 crc32) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(bos));
        CheckedOutputStream cos = new CheckedOutputStream(out, crc32);
        byte[] buf = new byte[8192];
        try {
            out.putNextEntry(new ZipEntry(entryName));
            int count = 0;
            try {
                while ((count = in.read(buf)) != -1) {
                    cos.write(buf, 0, count);
                }
            }
            finally {
                out.closeEntry();
            }
        }
        finally {
            out.close();
        }
        return bos.toByteArray();
    }

    public static byte[] uncompressContents(byte[] compressed, CRC32 crc32) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileContentsFactory.uncompressContents(compressed, baos, crc32);
        byte[] uncompressed = baos.toByteArray();
        baos.close();
        return uncompressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompressContents(byte[] compressed, OutputStream out, CRC32 crc32) throws IOException {
        try (ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(compressed)));){
            zin.getNextEntry();
            byte[] buf = new byte[8192];
            int count = 0;
            while ((count = zin.read(buf)) != -1) {
                crc32.update(buf, 0, count);
                out.write(buf, 0, count);
            }
        }
    }
}

