/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.List;

public class ExternalProcessUtil {
    public static final String PROPERTY_ALWAYS_DESTROY_PROCESSES = "com.sas.dpro.common.ExternalProcessUtil.alwaysDestroyProcesses";
    public static final String PROPERTY_DONT_CLOSE_STDIN = "com.sas.dpro.common.ExternalProcessUtil.dontCloseStdin";
    public static final String PROPERTY_DEBUG_WAITFOR = "com.sas.dpro.common.ExternalProcessUtil.waitFor.debug";
    private static final boolean DEBUG_WAITFOR = Boolean.getBoolean("com.sas.dpro.common.ExternalProcessUtil.waitFor.debug");

    private ExternalProcessUtil() {
    }

    private static final boolean checkAlwaysDestroyProcess(Process proc) {
        boolean destroy = Boolean.getBoolean(PROPERTY_ALWAYS_DESTROY_PROCESSES);
        if (DEBUG_WAITFOR) {
            ExternalProcessUtil.debugWaitForPrint("... always call proc.destroy()? - " + destroy);
        }
        if (destroy) {
            proc.destroy();
            if (DEBUG_WAITFOR) {
                ExternalProcessUtil.debugWaitForPrint("... done calling proc.destroy()");
            }
        }
        return destroy;
    }

    public static final String createCommandString(List command) {
        String[] array = new String[command.size()];
        array = command.toArray(array);
        return ExternalProcessUtil.createCommandString(array);
    }

    public static final String createCommandString(String[] cmdArray) {
        StringBuilder sb = new StringBuilder(cmdArray[0]);
        for (int i = 1; i < cmdArray.length; ++i) {
            sb.append(' ');
            if (cmdArray[i].indexOf(32) > -1 || cmdArray[i].indexOf(9) > -1) {
                sb.append('\"').append(cmdArray[i]).append('\"');
                continue;
            }
            sb.append(cmdArray[i]);
        }
        return sb.toString();
    }

    private static final synchronized void debugWaitForPrint(String text) {
        text = "[DEBUG ExProcUtil]: " + text;
        System.err.println(text);
    }

    public static int waitFor(Process proc, PrintWriter stdoutWriter, PrintWriter stderrWriter, Appendable stdoutBuf, Appendable stderrBuf) throws Exception {
        return ExternalProcessUtil.waitFor(proc, stdoutWriter, stderrWriter, stdoutBuf, stderrBuf, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int waitFor(Process proc, PrintWriter stdoutWriter, PrintWriter stderrWriter, Appendable stdoutBuf, Appendable stderrBuf, String stdin) throws Exception {
        if (DEBUG_WAITFOR) {
            ExternalProcessUtil.debugWaitForPrint("waitFor: Entering");
        }
        ProcessStreamReaderThread stdoutThread = null;
        ProcessStreamReaderThread stderrThread = null;
        if (DEBUG_WAITFOR) {
            ExternalProcessUtil.debugWaitForPrint("... creating stdout and stderr reader threads");
        }
        InputStream outStream = proc.getInputStream();
        InputStream errStream = proc.getErrorStream();
        if (errStream == outStream) {
            errStream = null;
            if (DEBUG_WAITFOR) {
                ExternalProcessUtil.debugWaitForPrint("... *** outStream==errStream, so only creating 1 reader thread");
            }
        }
        stdoutThread = new ProcessStreamReaderThread("stdout", outStream, stdoutBuf);
        stdoutThread.setOutputWriter(stdoutWriter);
        if (errStream != null) {
            stderrThread = new ProcessStreamReaderThread("stderr", errStream, stderrBuf);
            stderrThread.setOutputWriter(stderrWriter);
        }
        if (DEBUG_WAITFOR) {
            ExternalProcessUtil.debugWaitForPrint("... starting stdout and stderr reader threads");
        }
        stdoutThread.start();
        if (stderrThread != null) {
            stderrThread.start();
        }
        PrintWriter stdinWriter = null;
        if (stdin != null) {
            if (DEBUG_WAITFOR) {
                ExternalProcessUtil.debugWaitForPrint("... stdin text specified.  Writing stdin to process's input stream");
            }
            Charset cs = Charset.defaultCharset();
            stdinWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(proc.getOutputStream(), cs)));
            try {
                stdinWriter.print(stdin);
                stdinWriter.flush();
            }
            finally {
                stdinWriter.close();
            }
            stdinWriter = null;
        } else if (DEBUG_WAITFOR) {
            ExternalProcessUtil.debugWaitForPrint("... no stdin specified");
        }
        int rc = 0;
        try {
            if (DEBUG_WAITFOR) {
                ExternalProcessUtil.debugWaitForPrint("... calling proc.waitFor()");
            }
            rc = proc.waitFor();
            if (DEBUG_WAITFOR) {
                ExternalProcessUtil.debugWaitForPrint("... proc.waitFor() done.  rc: " + rc);
            }
        }
        catch (Exception e) {
            if (DEBUG_WAITFOR) {
                ExternalProcessUtil.debugWaitForPrint("... !!! Exception in proc.waitFor(): " + e.getMessage());
                ExternalProcessUtil.debugWaitForPrint("... !!! Interrupting stdout & stderr threads");
            }
            stdoutThread.interrupt();
            if (stderrThread != null) {
                stderrThread.interrupt();
            }
            throw e;
        }
        finally {
            block44: {
                if (DEBUG_WAITFOR) {
                    ExternalProcessUtil.debugWaitForPrint("... calling stdoutThread.join()");
                }
                stdoutThread.join();
                if (stderrThread != null) {
                    if (DEBUG_WAITFOR) {
                        ExternalProcessUtil.debugWaitForPrint("... calling stderrThread.join()");
                    }
                    stderrThread.join();
                }
                if (stdoutWriter != null) {
                    if (DEBUG_WAITFOR) {
                        ExternalProcessUtil.debugWaitForPrint("... closing stdout writer");
                    }
                    stdoutWriter.flush();
                    stdoutWriter.close();
                }
                if (stderrWriter != null && stderrWriter != stdoutWriter) {
                    if (DEBUG_WAITFOR) {
                        ExternalProcessUtil.debugWaitForPrint("... closing stderr writer");
                    }
                    stderrWriter.flush();
                    stderrWriter.close();
                }
                if (DEBUG_WAITFOR) {
                    ExternalProcessUtil.debugWaitForPrint("... closing proc's stdout stream");
                }
                stdoutThread.cleanup();
                if (stderrThread != null) {
                    if (DEBUG_WAITFOR) {
                        ExternalProcessUtil.debugWaitForPrint("... closing proc's stderr stream");
                    }
                    stderrThread.cleanup();
                }
                if (!Boolean.getBoolean(PROPERTY_DONT_CLOSE_STDIN)) {
                    if (DEBUG_WAITFOR) {
                        ExternalProcessUtil.debugWaitForPrint("... closing proc's stdin stream");
                    }
                    try {
                        proc.getOutputStream().close();
                        if (stdinWriter != null) {
                            stdinWriter.close();
                        }
                        break block44;
                    }
                    catch (IOException ioe) {
                        if (DEBUG_WAITFOR) {
                            ExternalProcessUtil.debugWaitForPrint("... !!! Error closing stdin stream: " + ioe.getMessage());
                        }
                        break block44;
                    }
                }
                if (DEBUG_WAITFOR) {
                    ExternalProcessUtil.debugWaitForPrint("... *** NOTE: proc's stdin stream NOT being closed");
                }
            }
            ExternalProcessUtil.checkAlwaysDestroyProcess(proc);
        }
        return rc;
    }

    static class ProcessStreamReaderThread
    extends Thread {
        private BufferedReader r;
        private PrintWriter outputWriter;
        private Appendable buffer;
        private boolean hadIOException;

        public ProcessStreamReaderThread(String name, InputStream in, Appendable buffer) {
            super(name);
            this.r = new BufferedReader(new InputStreamReader(in));
            this.buffer = buffer;
            this.hadIOException = false;
        }

        public void cleanup() {
            block4: {
                if (DEBUG_WAITFOR) {
                    ExternalProcessUtil.debugWaitForPrint("... Thread " + this.getName() + ": closing output stream reader");
                }
                try {
                    this.r.close();
                }
                catch (IOException ioe) {
                    if (!DEBUG_WAITFOR) break block4;
                    ExternalProcessUtil.debugWaitForPrint("... Thread " + this.getName() + ": !!! Error closing output stream reader: " + ioe.getMessage());
                }
            }
            if (DEBUG_WAITFOR) {
                ExternalProcessUtil.debugWaitForPrint("... Thread " + this.getName() + ": done.");
            }
        }

        public boolean hadIOException() {
            return this.hadIOException;
        }

        @Override
        public void run() {
            if (DEBUG_WAITFOR) {
                ExternalProcessUtil.debugWaitForPrint("... Thread " + this.getName() + ": reader thread starting");
            }
            try {
                if (this.buffer != null) {
                    String line;
                    while ((line = this.r.readLine()) != null) {
                        this.buffer.append(line).append('\n');
                        if (this.outputWriter == null) continue;
                        this.outputWriter.println(line);
                    }
                } else {
                    String line;
                    while ((line = this.r.readLine()) != null) {
                        if (this.outputWriter == null) continue;
                        this.outputWriter.println(line);
                    }
                }
            }
            catch (IOException ioe) {
                if (DEBUG_WAITFOR) {
                    ExternalProcessUtil.debugWaitForPrint("... Thread " + this.getName() + ": !!! IO error reading stream: " + ioe.getMessage());
                }
                String desc = "Error reading IO stream: {0}";
                desc = MessageFormat.format(desc, ioe.getMessage());
                try {
                    if (this.buffer != null) {
                        this.buffer.append(desc);
                    }
                    ioe.printStackTrace();
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace();
                }
                this.hadIOException = true;
            }
            if (DEBUG_WAITFOR) {
                ExternalProcessUtil.debugWaitForPrint("... Thread " + this.getName() + ": reader thread ending.");
            }
        }

        public void setOutputWriter(PrintWriter w) {
            this.outputWriter = w;
        }
    }
}

